<?php
namespace controller;
use ControllerScheme;
use FwHtml\Elements\Tags\Main\HtmlTags;

class Comments extends ControllerScheme {
    const name = 'کامنت';

    public function changeStatus()
    {
        $status = $this->requestArray()['status'];
        $id = $this->requestArray()['id'];

        $change = $this->model()::edit($id,[
            'status' => $status=="0"?1:0
        ]);

        if ($change){
            return "1";
        }else{
            return "0";
        }
    }


    public function fetchReplies() {
        $comment_id = $this->requestArray()['id'];
        $replies = \model\Comments::getAllFiltered('reply_id', $comment_id);

        // اگر اپیزودی وجود نداشت
        if ($replies->isEmpty()) {
            return HtmlTags::Div('.alert.alert-warning')->Content('هیچ پاسخی برای این کامنت موجود نیست.');
        }

        return HtmlTags::Section('.content')->Content(
            HtmlTags::Div('.row')->Content(
                HtmlTags::Div('.col-md-12')->Content(
                    HtmlTags::Div('.card.card-primary.card-outline')->Content(
                        HtmlTags::Div('.card-body.d-flex.flex-wrap')->Content(
                            HtmlTags::Div('.table-responsive')->Content(  // اضافه کردن کلاس table-responsive
                                HtmlTags::Table('.table.table-bordered.table-striped.w-100')->Content(  // اضافه کردن کلاس w-100
                                    HtmlTags::Thead('.table-dark')->Content(
                                        HtmlTags::Tr()->Content(
                                            HtmlTags::Th('ردیف')->Width('50'),
                                            HtmlTags::Th('کاربر'),
                                            HtmlTags::Th('پاسخ'),
                                        )
                                    ),
                                    HtmlTags::Tbody()->Content(
                                        array_map(function($reply, $index) {
                                            $user = \model\Users::get($reply->user_id);
                                            return HtmlTags::Tr()->Content(
                                                HtmlTags::Td($index + 1),
                                                HtmlTags::Td($user->name." ( ".$user->mobile." ) "),
                                                HtmlTags::Td($reply->comment_text),
                                            );
                                        }, iterator_to_array($replies), array_keys(iterator_to_array($replies)))
                                    )
                                )
                            )
                        )
                    )
                )
            )
        );


    }



}