<?php
namespace controller;
use ControllerScheme;
use FwHtml\Elements\Tags\Main\HtmlTags;
use FwHtml\Elements\Tags\Option;

class PoemCategories extends ControllerScheme {
    const name = 'دسته بندی';


    public function getCategories(){
        $poet_id=$this->requestArray()['poet_id'];
        $output[]=HtmlTags::Option()->Selected()->Value(0)->Content('دسته بندی اصلی');
        foreach (\model\PoemCategories::getAllFiltered('poet_id',$poet_id) as $item){
            $output[]=HtmlTags::Option()->Value($item->poem_category_id)->Content($item->poem_category_name);
        }
        return implode('',$output);
    }
    public function getCategoriesPoem(){
        $poet_id=$this->requestArray()['poet_id'];
        $output=[];
        foreach (\model\PoemCategories::Db()->where('poet_id',$poet_id)->where('parent_id',0)->get() as $item){
            $output[]=HtmlTags::Option()->Value($item->poem_category_id)->Content($item->poem_category_name);
        }
        return implode('',$output);
    }



    public function getSubCats() {
        $id = $this->requestArray()['id'];
        if ($id > 0) {
            $result = \model\PoemCategories::Db()->where('parent_id', $id)->get();
            $output = [];
            foreach ($result as $item) {
                    $output[] = HtmlTags::Option()->Value($item->poem_category_id)->Content($item->poem_category_name);
            }
            return implode('', $output);

        }
        return '';

    }


}