<?php

namespace controller;

use DATABASE\Model;
use FwBase\Reports\ReportScheme;
use FwHtml\Elements\Tags\Main\HtmlTags;

class SaleReports extends ReportScheme {
	public function getReport() {
		ob_start();
		$start_date = $this->isSet('date_from', function ($date_from) {
			if ($date_from == null) {
				return null;
			}
			return persianStrToTime($date_from);
		});
		$end_date = $this->isSet('date_to', function ($date_to) {
			if ($date_to == null) {
				return null;
			}
			return persianStrToTime($date_to);
		});

		$user_id = $this->isSet('user_id', function ($user_id) {
			if (is_numeric($user_id) and $user_id > 0) {
				return $user_id;
			}
			return null;
		});

		$payment_type = $this->isSet('payment_type', function ($payment_type) {
			if (is_numeric($payment_type) and $payment_type > 0) {
				return $payment_type;
			}
			return null;
		});

		$payment_status = $this->isSet('payment_status', function ($payment_status) {
			if (is_numeric($payment_status) and $payment_status > 0) {
				return $payment_status;
			}
			return null;
		});


		$db = \model\PaymentTable::Db()->where('payment_id', '>', '0');
		if ($start_date) {
			$db->where('payment_date', '>=', $start_date);
		}
		if ($end_date) {
			$db->where('payment_date', '<=', $end_date);
		}
		if ($user_id) {
			$db->where('user_id', '=', $user_id);
		}
		if ($payment_type) {
			$payment_type == 1 ? $db->where('payment_type', '=', "buyBooks") : $db->where('payment_type', '=', "buyPlan");
		}

		if ($payment_status) {
			$payment_status == 1 ? $db->where('payment_status', '=', "1") : $db->where('payment_status', 'IS', null);
		}

		$res = $db->get()->values()->all();
		$rows = [];
		$DeliveryReportView = new \view\SaleReports($this);
		$i = 0;
		foreach ($res as $order) {
			$rows[] = $DeliveryReportView->toRow($order, $i);
			$res[] = $order;
		}

		$todayIncome = \model\PaymentTable::Db()->where('payment_status', 1)->where('payment_date', '>', strtotime("yesterday") - 1)->sum('payment_amount') / 10;
		$todayIncomeFromBook = \model\PaymentTable::Db()->where('payment_status', 1)->where('payment_type', 'buyBooks')->where('payment_date', '>', strtotime("yesterday") - 1)->sum('payment_amount') / 10;
		$todayIncomeFromPlan = \model\PaymentTable::Db()->where('payment_status', 1)->where('payment_type', 'buyPlan')->where('payment_date', '>', strtotime("yesterday") - 1)->sum('payment_amount') / 10;

		$weeklyIncome = \model\PaymentTable::Db()->where('payment_status', 1)->where('payment_date', '>', strtotime("-7 days") - 1)->sum('payment_amount') / 10;
		$weeklyIncomeFromBook = \model\PaymentTable::Db()->where('payment_status', 1)->where('payment_type', 'buyBooks')->where('payment_date', '>', strtotime("-7 days") - 1)->sum('payment_amount') / 10;
		$weeklyIncomeFromPlan = \model\PaymentTable::Db()->where('payment_status', 1)->where('payment_type', 'buyPlan')->where('payment_date', '>', strtotime("-7 days") - 1)->sum('payment_amount') / 10;

		$monthlyIncome = \model\PaymentTable::Db()->where('payment_status', 1)->where('payment_date', '>', strtotime("-1 month") - 1)->sum('payment_amount') / 10;
		$monthlyIncomeFromBook = \model\PaymentTable::Db()->where('payment_status', 1)->where('payment_type', 'buyBooks')->where('payment_date', '>', strtotime("-1 month") - 1)->sum('payment_amount') / 10;
		$monthlyIncomeFromPlan = \model\PaymentTable::Db()->where('payment_status', 1)->where('payment_type', 'buyPlan')->where('payment_date', '>', strtotime("-1 month") - 1)->sum('payment_amount') / 10;

		$yearlyIncome = \model\PaymentTable::Db()->where('payment_status', 1)->where('payment_date', '>', strtotime("-1 year") - 1)->sum('payment_amount') / 10;
		$yearlyIncomeFromBook = \model\PaymentTable::Db()->where('payment_status', 1)->where('payment_type', 'buyBooks')->where('payment_date', '>', strtotime("-1 year") - 1)->sum('payment_amount') / 10;
		$yearlyIncomeFromPlan = \model\PaymentTable::Db()->where('payment_status', 1)->where('payment_type', 'buyPlan')->where('payment_date', '>', strtotime("-1 year") - 1)->sum('payment_amount') / 10;

		$totalIncome = \model\PaymentTable::Db()->where('payment_status', 1)->sum('payment_amount') / 10;
		$totalIncomeFromBook = \model\PaymentTable::Db()->where('payment_status', 1)->where('payment_type', 'buyBooks')->sum('payment_amount') / 10;
		$totalIncomeFromPlan = \model\PaymentTable::Db()->where('payment_status', 1)->where('payment_type', 'buyPlan')->sum('payment_amount') / 10;
		$totalIncomeFromPlanTransfer = \model\PaymentTable::Db()->where('payment_status', 1)->where('payment_type', 'buyPlan_card')->sum('payment_amount') / 10;

		$html = HtmlTags::Div('.card-body')->Attrs(['style' => 'overflow-x: scroll'])->Content(

//			$this->addCard(price_format($todayIncome), 'درآمد امروز', 'success'),
//			$this->addCard(price_format($todayIncomeFromBook), 'درآمد امروز از فروش کتاب', 'success'),
//			$this->addCard(price_format($todayIncomeFromPlan), 'درآمد امروز از فروش اشتراک', 'success'),
//
//			$this->addCard(price_format($weeklyIncome), 'درآمد هفته', 'warning'),
//			$this->addCard(price_format($weeklyIncomeFromBook), 'درآمد هفته از فروش کتاب', 'warning'),
//			$this->addCard(price_format($weeklyIncomeFromPlan), 'درآمد هفته از فروش اشتراک', 'warning'),
//
//			$this->addCard(price_format($monthlyIncome), 'درآمد ماه جاری', 'danger'),
//			$this->addCard(price_format($monthlyIncomeFromBook), 'درآمد ماه جاری از فروش کتاب', 'danger'),
//			$this->addCard(price_format($monthlyIncomeFromPlan), 'درآمد ماه جاری از فروش اشتراک', 'danger'),

			$this->addCard(price_format($totalIncome), 'درآمد کل', 'primary',3),
			$this->addCard(price_format($totalIncomeFromBook), 'درآمد کل از فروش کتاب', 'primary',3),
			$this->addCard(price_format($totalIncomeFromPlan), 'درآمد کل از فروش اشتراک', 'primary',3),
			$this->addCard(price_format($totalIncomeFromPlanTransfer), 'درآمد کل از کارت به کارت', 'primary',3),


			HtmlTags::Table('.table.table-bordered')->Content(
				HtmlTags::Thead('.table-dark')->Content(
					$DeliveryReportView->thList()
				),
				HtmlTags::Tbody()->Content(
					implode('', $rows)
				)
			)
		);
		if (sizeof($res) === 0) {
			$html = HtmlTags::Div('.text-center.m-5')->Content(
				"نتیجه ای یافت نشد"
			);
		}
		echo json_encode([
			'status' => true,
			'html'   => $html
		]);
	}

	private function addCard(string $showNumber, string $nameFiled, string $color = "success", string $size = "4", string $link = "", string $id = ""): \FwHtml\Elements\Tags\Div {
		return HtmlTags::Div(".col-md-$size.d-inline-block")->Content(
			HtmlTags::Div(".small-box.card.card-$color.card-outline")->Content(
				HtmlTags::Div('.inner.text-center')->Content(
					HtmlTags::H3($showNumber),
					HtmlTags::P($nameFiled)
				)
			)
		);
	}

	protected function setModel(Model $model = null): void {
		$this->model = new \model\PaymentTable();
		$this->setKey($this->model->_key);
	}

}
