<?php

namespace controller;

use ControllerScheme;
use FwAuthSystem\Main\UserObject;
use FwHtml\Elements\Tags\Main\HtmlTags;
use model\Entity\DailyRecordsEntity;

class Stories extends ControllerScheme {
    const name = 'داستان';

    public static $__uploads = ["story_cover" => __SOURCE__ . "images/Stories/"];

    protected function add(?bool $csrf = true) {
        $dailyCheck = $this->requestArray()['is_daily'];
        if ($dailyCheck == 1) {
            $last_id = \model\Stories::LastId();
            \model\DailyRecords::add([
                                         'story_id' => $last_id + 1
                                     ]);
        }

        $this->changeRequestValue('story_start_date', strtotime('today'));
        return parent::add($csrf); // TODO: Change the autogenerated stub
    }

    public function edit() {
        $storyId = $this->requestArray()['story_id'];
        $dailyCheck = $this->requestArray()['is_daily'];
        $is_ended = $this->requestArray()['is_ended'];
        if ($dailyCheck == 1) {
            \model\DailyRecords::add(['story_id' => $storyId]);

            $this->changeRequestValue('plan_id', 0);

            if ($is_ended == 1) {
                $this->changeRequestValue('is_daily', 0);
                $this->changeRequestValue('plan_id', 3);
            }
        }


        return parent::edit(); // TODO: Change the autogenerated stub
    }

    public function changeStatus() {
        $status = $this->requestArray()['status'];
        $id = $this->requestArray()['id'];
        if ($status == "1") {
            $is_daily = \model\Stories::get($id)->is_daily;
            if ($is_daily == 1) {
                $change = $this->model()::edit($id, [
                    'is_ended' => 1,
                    'is_daily' => 0,
                    'plan_id'  => 3
                ]);
            } else {
                $change = $this->model()::edit($id, [
                    'is_ended' => 1,
                ]);
            }

        } elseif ($status == "0") {
            $checkDaily = \model\DailyRecords::getOneFiltered('story_id', $id);
            if ($checkDaily instanceof DailyRecordsEntity) {
                $change = $this->model()::edit($id, [
                    'is_ended' => 0,
                    'is_daily' => 1,
                    'plan_id'  => 0
                ]);
            } else {
                $change = $this->model()::edit($id, [
                    'is_ended' => 0,
                ]);
            }
        }


        if ($change) {
            return "1";
        } else {
            return "0";
        }
    }

    //public function fetchEpisodes() {
    //    $storyId = $this->requestArray()['id'];
    //    $episodes = \model\Episodes::getAllFiltered('story_id', $storyId);
    //    return HtmlTags::Section('.content')->Content(
    //        HtmlTags::Div('.row')->Content(
    //            HtmlTags::Div('.col-md-12')->Content(
    //                HtmlTags::Div('.card.card-primary.card-outline')->Content(
    //                    HtmlTags::Div('.card-body.d-flex.flex-wrap')->Content(
    //                        HtmlTags::Table('.table.table-bordered.table-striped')->Content(
    //                            HtmlTags::Thead('.table-dark')->Content(
    //                                HtmlTags::Tr()->Content(
    //                                    HtmlTags::Th('ردیف')->Width('50'),
    //                                    HtmlTags::Th('داستان'),
    //                                    HtmlTags::Th('اپیزود'),
    //                                    HtmlTags::Th('تاریخ انتشار'),
    //                                    HtmlTags::Th('.no-sort عملیات')->Width('150')
    //                                )
    //                            ),
    //                            HtmlTags::Tbody()->Content(
    //
    //                                array_map(function($episode, $index) {
    //                                    return HtmlTags::Tr()->Content(
    //                                        HtmlTags::Td($index + 1),
    //                                        HtmlTags::Td($episode->story_name),
    //                                        HtmlTags::Td($episode->episode_name),
    //                                        HtmlTags::Td(jdate('Y/m/d', $episode->release_date)),
    //                                        HtmlTags::Td()->Content(
    //                                            HtmlTags::Button('.btn.btn-sm.btn-outline-primary')
    //                                                    ->Content('مشاهده')
    //                                                    ->Data('id', $episode->episode_id)
    //                                        )
    //                                    );
    //                                }, $episodes, array_keys($episodes))
    //
    //                            )
    //                        )
    //                    )
    //                )
    //            )
    //        )
    //    );
    //}

    public function fetchEpisodes() {
        $storyId = $this->requestArray()['id'];
        $episodes = \model\Episodes::getAllFiltered('story_id', $storyId);

        // اگر اپیزودی وجود نداشت
        if ($episodes->isEmpty()) {
            return HtmlTags::Div('.alert.alert-warning')->Content('هیچ اپیزودی برای این داستان موجود نیست.');
        }

        // ایجاد جدول اپیزودها
        //return HtmlTags::Section('.content')->Content(
        //    HtmlTags::Div('.row')->Content(
        //        HtmlTags::Div('.col-md-12')->Content(
        //            HtmlTags::Div('.card.card-primary.card-outline')->Content(
        //                HtmlTags::Div('.card-body.d-flex.flex-wrap')->Content(
        //                    HtmlTags::Table('.table.table-bordered.table-striped')->Content(
        //                        HtmlTags::Thead('.table-dark')->Content(
        //                            HtmlTags::Tr()->Content(
        //                                HtmlTags::Th('ردیف')->Width('50'),
        //                                HtmlTags::Th('نام اپیزود'),
        //                                HtmlTags::Th('تاریخ انتشار'),
        //                                HtmlTags::Th('.no-sort عملیات')->Width('150')
        //                            )
        //                        ),
        //                        HtmlTags::Tbody()->Content(
        //                        // پیمایش بر روی اپیزودها با استفاده از foreach
        //                            array_map(function($episode, $index) {
        //                                return HtmlTags::Tr()->Content(
        //                                    HtmlTags::Td($index + 1),
        //                                    HtmlTags::Td($episode->episode_number),
        //                                    HtmlTags::Td(jdate('Y/m/d', $episode->episode_date)),
        //                                    HtmlTags::Td()->Content(
        //                                        HtmlTags::Button('.btn.btn-sm.btn-outline-primary.episodeView')
        //                                                ->Content('مشاهده')
        //                                                ->Data('id', $episode->episode_id)
        //                                    )
        //                                );
        //                            }, iterator_to_array($episodes), array_keys(iterator_to_array($episodes)))
        //                        )
        //                    )
        //                )
        //            )
        //        )
        //    )
        //);

        return HtmlTags::Section('.content')->Content(
            HtmlTags::Div('.row')->Content(
                HtmlTags::Div('.col-md-12')->Content(
                    HtmlTags::Div('.card.card-primary.card-outline')->Content(
                        HtmlTags::Div('.card-body.d-flex.flex-wrap')->Content(
                            HtmlTags::Div('.table-responsive')->Content(  // اضافه کردن کلاس table-responsive
                                HtmlTags::Table('.table.table-bordered.table-striped.w-100')->Content(  // اضافه کردن کلاس w-100
                                    HtmlTags::Thead('.table-dark')->Content(
                                        HtmlTags::Tr()->Content(
                                            HtmlTags::Th('ردیف')->Width('50'),
                                            HtmlTags::Th('نام اپیزود'),
                                            HtmlTags::Th('تاریخ انتشار'),
                                            HtmlTags::Th('.no-sort عملیات')->Width('150')
                                        )
                                    ),
                                    HtmlTags::Tbody()->Content(
                                        array_map(function($episode, $index) {
                                            return HtmlTags::Tr()->Content(
                                                HtmlTags::Td($index + 1),
                                                HtmlTags::Td($episode->episode_number),
                                                HtmlTags::Td(jdate('Y/m/d', $episode->episode_date)),
                                                HtmlTags::Td()->Content(
                                                    HtmlTags::Button('.btn.btn-sm.btn-outline-primary.episodeView')
                                                            ->Content('مشاهده')
                                                            ->Data('id', $episode->episode_id)
                                                )
                                            );
                                        }, iterator_to_array($episodes), array_keys(iterator_to_array($episodes)))
                                    )
                                )
                            )
                        )
                    )
                )
            )
        );


    }


}