<?php

namespace controller;

use ControllerScheme;
use FwHtml\Elements\Tags\Main\HtmlTags;
use model\Entity\EventsEntity;
use model\Entity\MembershipsEntity;
use model\Entity\UsersEntity;
use model\Events;
use model\Participations;
use model\PaymentTable;
use model\Points;
use model\Scores;

class Users extends ControllerScheme
{
    const name = 'کاربر';

    public static $__uploads = ["user_avatar" => __SOURCE__ . "images/Users/"];

    public function sendTest()
    {
        $userId = $this->requestArray('userId');
        $user = \model\Users::get($userId);
        if ($user instanceof UsersEntity) {
            return sendPushNotification($user->firebase_token, "New Message", json_encode([
                'type' => 'test',
                'content' => 'hi',
            ]));
        }
    }

    public function toggleBlock()
    {
        $userId = $this->requestArray('userId');
        $status = $this->requestArray('status');
        if (\model\Users::edit($userId, [
            'is_locked' => $status == 'block' ? 1 : 0,
        ])) {
            return 'ok';
        }
        return 'fail';
    }

    public function sensSMS()
    {
        $mobile = $this->requestArray()['mobile'];
        $text = $this->requestArray()['text'];
        $sms = sendVerify($mobile, [$text]);
        if ($sms) {
            return '1';
        } else {
            return '2';
        }

    }

    public function cardPayments()
    {
        $payments = PaymentTable::Db()->where('payment_type', 'buyPlan_card')->where('payment_status', 'is', null)->get();
        return $this->view($this->viewName(), 'cardPayments', [
            $payments
        ]);
    }

    public function cryptoPayments()
    {
        $payments = PaymentTable::Db()->where('payment_type', 'buyPlan_crypto')->where('payment_status', 'is', null)->get();
        return $this->view($this->viewName(), 'cryptoPayments', [
            $payments
        ]);
    }

    public function confirmPayment()
    {
        $paymentData = PaymentTable::get($this->requestArray('paymentId'));
        $data = json_decode($paymentData->payment_data);
        $user = \model\Users::get($paymentData->user_id);
        if ($user instanceof UsersEntity) {
            if ($paymentData->payment_type == 'buyPlan_card' || $paymentData->payment_type == 'buyPlan_crypto') {
                if (PaymentTable::edit($paymentData->payment_id, [
                    'payment_refnum' => $paymentData->payment_resnum . "_" . date("YmdHis"),
                    'payment_status' => 1,
                ])) {
                    if (\model\Users::edit($data->userId, [
                        'membership_id' => $data->membershipId ?? 0,
                        'membership_activated_at' => time(),
                        'membership_expired_at' => strtotime('+1 month', time()),
                    ])) {
                        $plan = \model\Memberships::get($data->membershipId);
                        if ($plan instanceof MembershipsEntity) {
                            sendSmsPattern($user->mobile, 250277, [
                                $plan->name,
                                jdate("Y/m/d", strtotime('+1 month', time()))
                            ]);
                        }
                        return "1";
                    }
                }
            } else if ($paymentData->payment_type == 'event_registration_card' || $paymentData->payment_type == 'event_registration_crypto') {
                if (PaymentTable::edit($paymentData->payment_id, [
                    'payment_refnum' => $paymentData->payment_resnum . "_" . date("YmdHis"),
                    'payment_status' => 1,
                ])) {
                    /** @var EventsEntity $event */
                    $event = Events::get($data->eventId);
                    $id = Participations::add([
                        'participation_count' => $data->count,
                        'participation_cost' => $paymentData->payment_amount / 10,
                        'user_id' => $user->user_id,
                        'event_id' => $event->event_id,
                    ]);
                    Points::award($user, Scores::getBy(9), $event->name);
                    sendSmsPattern($user->mobile, 289323, [
                        $event->name,
                        $event->datetime,
                        $id,
                    ]);
                    return "1";
                }
            }
        }
        return "0";
    }

    public function confirmDocs()
    {
        $users = \model\Users::Db()->where('user_type', 1)->get();

        return $this->view($this->viewName(), 'confirmDocs', [
            $users
        ]);
    }

    public function showDocs()
    {
        $userId = $this->requestArray()['id'];
        $user = \model\Users::get($userId);
        return
            HtmlTags::Div('.form-group.col-md-4')->Content(
                HtmlTags::Label()->Class('')->Id('')->For('')->Content('نام کاربر').
                HtmlTags::Input(".form-control")->Value($user->user_name?:"ثبت نشده")->Disabled()
            ).
            HtmlTags::Div('.form-group.col-md-4')->Content(
                HtmlTags::Label()->Class('')->Id('')->For('')->Content('موبایل').
                HtmlTags::Input(".form-control")->Value($user->mobile)->Disabled()
            ).
            HtmlTags::Div('.form-group.col-md-4')->Content(
                HtmlTags::Label()->Class('')->Id('')->For('')->Content('کد ملی').
                HtmlTags::Input(".form-control")->Value($user->national_code?:"ثبت نشده")->Disabled()
            );



    }

    public function changeStatus()
    {
        $userId = $this->requestArray()['id'];
        $status = $this->requestArray()['status'];
        if (\model\Users::edit($userId,[
            'is_active' => $status
        ])){
            return 1;
        }else{
            return 0;
        }

    }

    protected function add(?bool $csrf = true)
    {
        $this->changeRequestValue('token', md5(time()));
        return parent::add($csrf); // TODO: Change the autogenerated stub
    }

    public function deletePayment()
    {
        if (PaymentTable::delete($this->requestArray('paymentId'))) {
            return "1";
        }
        return "0";
    }
}