import { PredicateFunction, UnknownAssignment } from './values';
import ExecutionPathOptions from './ExecutionPathOptions';
import Scope from './scopes/Scope';
import Module from '../Module';
import MagicString from 'magic-string';
import CallOptions from './CallOptions';
import Expression from './nodes/Expression';
import Declaration from './nodes/Declaration';
import { ObjectPath } from './variables/VariableReassignmentTracker';
export declare type ForEachReturnExpressionCallback = (options: ExecutionPathOptions) => (node: Node | UnknownAssignment) => void;
export default class Node {
    type: string;
    keys: string[];
    included: boolean;
    scope: Scope;
    start: number;
    end: number;
    leadingCommentStart: number;
    trailingCommentEnd: number;
    next: number;
    module: Module;
    parent: Node | Module;
    __enhanced: boolean;
    constructor();
    /**
     * Called once all nodes have been initialised and the scopes have been populated.
     * Usually one should not override this function but override bindNode and/or
     * bindChildren instead.
     */
    bind(): void;
    /**
     * Reassign a given path of an object.
     * E.g., node.reassignPath(['x', 'y']) is called when something
     * is assigned to node.x.y.
     * The default noop implementation is ok as long as hasEffectsWhenAssignedAtPath
     * always returns true for this node. Otherwise it should be overridden.
     * @param {String[]} _path
     * @param {ExecutionPathOptions} _options
     */
    reassignPath(_path: ObjectPath, _options: ExecutionPathOptions): void;
    /**
     * Override to control on which children "bind" is called.
     */
    bindChildren(): void;
    /**
     * Override this to bind assignments to variables and do any initialisations that
     * require the scopes to be populated with variables.
     */
    bindNode(): void;
    eachChild(callback: (node: Node) => void): void;
    /**
     * Executes the callback on each possible return expression when calling this node.
     * @param {String[]} _path
     * @param {CallOptions} _callOptions
     * @param {Function} _callback
     * @param {ExecutionPathOptions} _options
     */
    forEachReturnExpressionWhenCalledAtPath(_path: ObjectPath, _callOptions: CallOptions, _callback: ForEachReturnExpressionCallback, _options: ExecutionPathOptions): void;
    getValue(): {
        toString: () => string;
    };
    /**
     * Determine if this Node would have an effect on the bundle.
     * This is usually true for already included nodes. Exceptions are e.g. break statements
     * which only have an effect if their surrounding loop or switch statement is included.
     * The options pass on information like this about the current execution path.
     * @param {ExecutionPathOptions} options
     * @return {boolean}
     */
    hasEffects(options: ExecutionPathOptions): boolean;
    /**
     * @param {String[]} path
     * @param {ExecutionPathOptions} _options
     * @return {boolean}
     */
    hasEffectsWhenAccessedAtPath(path: ObjectPath, _options: ExecutionPathOptions): boolean;
    /**
     * @param {String[]} _path
     * @param {ExecutionPathOptions} _options
     * @return {boolean}
     */
    hasEffectsWhenAssignedAtPath(_path: ObjectPath, _options: ExecutionPathOptions): boolean;
    /**
     * @param {String[]} _path
     * @param {CallOptions} _callOptions
     * @param {ExecutionPathOptions} _options
     * @return {boolean}
     */
    hasEffectsWhenCalledAtPath(_path: ObjectPath, _callOptions: CallOptions, _options: ExecutionPathOptions): boolean;
    /**
     * Returns true if this node or any of its children is included.
     * @return {boolean}
     */
    hasIncludedChild(): boolean;
    /**
     * Includes the node in the bundle. Children are usually included if they are
     * necessary for this node (e.g. a function body) or if they have effects.
     * Necessary variables need to be included as well. Should return true if any
     * nodes or variables have been added that were missing before.
     * @return {boolean}
     */
    includeInBundle(): boolean;
    /**
     * Alternative version of includeInBundle to override the default behaviour of
     * declarations to only include nodes for declarators that have an effect. Necessary
     * for for-loops that do not use a declared loop variable.
     * @return {boolean}
     */
    includeWithAllDeclarations(): boolean;
    /**
     * Assign a scope to this node and make sure all children have the right scopes.
     * Perform any additional initialisation that does not depend on the scope being
     * populated with variables.
     * Usually one should not override this function but override initialiseScope,
     * initialiseNode and/or initialiseChildren instead. BlockScopes have a special
     * alternative initialisation initialiseAndReplaceScope.
     * @param {Scope} parentScope
     */
    initialise(parentScope: Scope): void;
    initialiseAndDeclare(_parentScope: Scope, _kind: string, _init: Declaration | Expression | UnknownAssignment | null): void;
    /**
     * Override to change how and with what scopes children are initialised
     * @param {Scope} _parentScope
     */
    initialiseChildren(_parentScope: Scope): void;
    /**
     * Override to perform special initialisation steps after the scope is initialised
     * @param {Scope} _parentScope
     */
    initialiseNode(_parentScope: Scope): void;
    /**
     * Override if this scope should receive a different scope than the parent scope.
     * @param {Scope} parentScope
     */
    initialiseScope(parentScope: Scope): void;
    insertSemicolon(code: MagicString): void;
    locate(): any;
    render(code: MagicString, es: boolean): void;
    /**
     * Start a new execution path to determine if this node has an effect on the bundle and
     * should therefore be included. Included nodes should always be included again in subsequent
     * visits as the inclusion of additional variables may require the inclusion of more child
     * nodes in e.g. block statements.
     * @return {boolean}
     */
    shouldBeIncluded(): boolean;
    someChild(callback: (node: Node) => boolean): boolean;
    /**
     * Returns true if some possible return expression when called at the given
     * path returns true. predicateFunction receives a `node` as parameter.
     * @param {String[]} _path
     * @param {CallOptions} _callOptions
     * @param {Function} predicateFunction
     * @param {ExecutionPathOptions} options
     * @returns {boolean}
     */
    someReturnExpressionWhenCalledAtPath(_path: ObjectPath, _callOptions: CallOptions, predicateFunction: (options: ExecutionPathOptions) => PredicateFunction, options: ExecutionPathOptions): boolean;
    toString(): string;
}
