import Module, { ModuleJSON } from './Module';
import ExternalModule from './ExternalModule';
import GlobalScope from './ast/scopes/GlobalScope';
import { InputOptions, IsExternalHook, Plugin, RollupWarning, SourceDescription, TreeshakingOptions, WarningHandler } from './rollup/index';
import { Node } from './ast/nodes/shared/Node';
import Bundle from './Bundle';
export declare type ResolveDynamicImportHandler = (specifier: string | Node, parentId: string) => Promise<string | void>;
export default class Graph {
    acornOptions: any;
    cachedModules: Map<string, ModuleJSON>;
    context: string;
    dynamicImport: boolean;
    externalModules: ExternalModule[];
    getModuleContext: (id: string) => string;
    hasLoaders: boolean;
    isExternal: IsExternalHook;
    isPureExternalModule: (id: string) => boolean;
    legacy: boolean;
    load: (id: string) => Promise<SourceDescription | string | void>;
    moduleById: Map<string, Module | ExternalModule>;
    modules: Module[];
    onwarn: WarningHandler;
    plugins: Plugin[];
    resolveDynamicImport: ResolveDynamicImportHandler;
    resolveId: (id: string, parent: string) => Promise<string | boolean | void>;
    scope: GlobalScope;
    treeshakingOptions: TreeshakingOptions;
    varOrConst: 'var' | 'const';
    dependsOn: {
        [id: string]: {
            [id: string]: boolean;
        };
    };
    stronglyDependsOn: {
        [id: string]: {
            [id: string]: boolean;
        };
    };
    treeshake: boolean;
    constructor(options: InputOptions);
    private loadModule(entryName);
    private link();
    buildSingle(entryModuleId: string): Promise<Bundle>;
    private analyseExecution(entryModule);
    private warnCycle(ordered, entryModules);
    private fetchModule(id, importer);
    private fetchAllDependencies(module);
    warn(warning: RollupWarning): void;
}
