# Complementary tools

A list of complementary tools built and maintained by the community.

## Analysis platform engines

-   [codacy-stylelint](https://github.com/codacy/codacy-stylelint): [Codacy](https://www.codacy.com/) engine for stylelint
-   [codeclimate-stylelint](https://github.com/gilbarbara/codeclimate-stylelint): Code Climate engine for stylelint

## Command Line Tools

-   [stylelint-find-rules](https://github.com/alexilyaev/stylelint-find-rules): Find Stylelint rules that you don't have in your config.

## Build tool plugins

-   [broccoli-stylelint](https://github.com/billybonks/broccoli-stylelint): A Broccoli plugin for stylelint.
-   [ember-cli-stylelint](https://github.com/billybonks/ember-cli-stylelint): An Ember CLI plugin for stylelint.
-   [grunt-stylelint](https://github.com/wikimedia/grunt-stylelint): A Grunt plugin for stylelint.
-   [gulp-stylelint](https://github.com/olegskl/gulp-stylelint): A gulp plugin for stylelint.
-   [stylelint-webpack-plugin](https://github.com/webpack-contrib/stylelint-webpack-plugin): A webpack plugin for stylelint.

## Editor plugins

-   [Ale](https://github.com/w0rp/ale): A Vim plugin that supports stylelint.
-   [Flycheck](https://github.com/flycheck/flycheck): An Emacs extension that supports stylelint.
-   [linter-stylelint](https://github.com/AtomLinter/linter-stylelint): An Atom plugin for stylelint.
-   [SublimeLinter-stylelint](https://github.com/SublimeLinter/SublimeLinter-stylelint): A Sublime Text plugin for stylelint.
-   [SublimeLinter-contrib-stylelint_d](https://github.com/jo-sm/SublimeLinter-contrib-stylelint_d): A Sublime Text plugin for stylelint that run's on daemon.
-   [vscode-stylelint](https://github.com/shinnn/vscode-stylelint): A Visual Studio Code extension for stylelint.

## Editors

-   [WebStorm](https://blog.jetbrains.com/webstorm/2016/09/webstorm-2016-3-eap-163-4830-stylelint-usages-for-default-exports-and-more/): Version 2016.3 onwards has built-in support for stylelint.

## Version Control

-   [Pre-commit](https://github.com/awebdeveloper/pre-commit-stylelint) A git pre-commit hook for stylelint
