'use strict';

exports.__esModule = true;
exports.default = preprocess;
function indentError(input, l, p) {
  throw input.error('Mixed tabs and spaces are not allowed', l, p + 1);
}

function preprocess(input, lines) {
  var indentType = void 0;
  var prevNumber = 0;
  var parts = lines.map(function (line) {
    var lastComma = false;
    var comment = false;
    var number = prevNumber + 1;
    var atrule = false;
    var indent = '';
    var tokens = [];
    var colon = false;

    if (line.length > 0) {
      if (line[0][0] === 'space') {
        indent = line[0][1];
        tokens = line.slice(1);
      } else {
        indent = '';
        tokens = line;
      }

      if (!indentType && indent.length) {
        indentType = indent[0] === ' ' ? 'space' : 'tab';
      }
      if (indentType === 'space') {
        if (indent.indexOf('\t') !== -1) {
          indentError(input, number, indent.indexOf('\t'));
        }
      } else if (indentType === 'tab') {
        if (indent.indexOf(' ') !== -1) {
          indentError(input, number, indent.indexOf(' '));
        }
      }

      if (tokens.length) {
        for (var i = tokens.length - 1; i >= 0; i--) {
          var type = tokens[i][0];
          if (type === ',') {
            lastComma = true;
            break;
          } else if (type === 'space') {
            continue;
          } else if (type === 'comment') {
            continue;
          } else if (type === 'newline') {
            continue;
          } else {
            break;
          }
        }
        comment = tokens[0][0] === 'comment';
        atrule = tokens[0][0] === 'at-word';

        var brackets = 0;
        for (var _i = 0; _i < tokens.length - 1; _i++) {
          var _type = tokens[_i][0];
          var next = tokens[_i + 1][0];
          if (_type === '(') {
            brackets += 1;
          } else if (_type === ')') {
            brackets -= 1;
          } else if (_type === ':' && brackets === 0 && (next === 'space' || next === 'newline')) {
            colon = true;
          }
        }
      }

      var last = tokens[tokens.length - 1];
      if (last && last[0] === 'newline') prevNumber = last[2];
    }

    return {
      number: number,
      indent: indent,
      colon: colon,
      tokens: tokens,
      atrule: atrule,
      comment: comment,
      lastComma: lastComma,
      before: ''
    };
  });

  parts = parts.reduceRight(function (all, i) {
    if (!i.tokens.length || i.tokens.every(function (j) {
      return j[0] === 'newline';
    })) {
      var prev = all[0];
      var before = i.indent + i.tokens.map(function (j) {
        return j[1];
      }).join('');
      prev.before = before + prev.before;
    } else {
      all.unshift(i);
    }
    return all;
  }, [{ end: true, before: '' }]);

  parts.forEach(function (part, i) {
    if (i === 0) return;

    var prev = parts[i - 1];
    var last = prev.tokens[prev.tokens.length - 1];
    if (last && last[0] === 'newline') {
      part.before = last[1] + part.before;
      prev.tokens.pop();
    }
  });

  return parts;
}
module.exports = exports['default'];
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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