<?php

namespace FwPagination\Controllers;
trait ControllersPagination {
	
	final public function fwPagination_getPaginationInfo() {
		header("Content-Type: application/json");
		$this->checkCurrentPage();
		return json_encode([
			'totalPages'  => $this->fwPagination_getTotalPageCount(),
			'currentPage' => $_SESSION[$this->class()]['pagination']['currentPage'],
			'limit'       => $_SESSION[$this->class()]['pagination']['limit'],
			'isOk'        => true,
		]);
	}
	
	private function fwPagination_getTotalPageCount() {
		return ceil($this->model()::Db()->rowCount() / $_SESSION[$this->class()]['pagination']['limit']);
	}
	
	final protected function fwPagination_goToNthPage() {
		$_SESSION[$this->class()]['pagination']['currentPage'] = $this->requestArray()['num'];
		return $this->main();
	}
	
	public function main() {
		$this->model()->paginate()->changeLimit($_SESSION[$this->class()]['pagination']['limit']);
		return $this->view($this->viewName(), 'main', [
			$this->model()->paginate()->nthPage($_SESSION[$this->class()]['pagination']['currentPage']),
		]);
	}
	
	final protected function fwPagination_changeLimit() {
		$limit = $this->requestArray()['limit'];
		$_SESSION[$this->class()]['pagination']['limit'] = $limit;
		if ($limit >= $this->model()::Db()->rowCount()) {
			$_SESSION[$this->class()]['pagination']['currentPage'] = 0;
		}
		$this->checkCurrentPage();
		return $this->main();
	}
	
	public function checkCurrentPage() {
		$total = $this->fwPagination_getTotalPageCount();
		if ($_SESSION[$this->class()]['pagination']['currentPage'] > $total) {
			$_SESSION[$this->class()]['pagination']['currentPage'] = $total - 2;
		}
	}
}
