<?php

namespace DATABASE\ORM\QueryBuilder\QueryBuilder;

use DATABASE\Model;
use DATABASE\ORM\QueryBuilder\DBCollection;
use FwConnection;
use Generator;
use PDO;
use stdClass;
use Str;

/**
 * @property array where_clause
 */
trait QueryBuilder {
	/**
	 * @var string
	 */
	private string $___table;
	/**
	 * @var PDO
	 */
	private PDO $conn;

	/**
	 * @var string
	 */
	private string $query_string = '';
	/**
	 * @var array
	 */
	private array $__where_clause = [];

	private string $__type = 'select';
	private array $__order_by = [];
	private array $__offset = [];
	private array $__limit = [];
	private array $__groupBy = [];
	private array $__having = [];
	private array $__joins = [];

	private bool $__isCustom = false;
	/**
	 * @var array
	 */
	private array $methods = [];

	private $___entity = stdClass::class;

	/**
	 * DB constructor.
	 */
	final public function __start() {
		if ($this instanceof Model or $this instanceof Db) {
			$this->___table = $this->_table;
		}
		if ($this->_Entity !== NULL) {
			$this->___entity = new $this->_Entity();
		}
		$this->conn = FwConnection::$conn;
	}

	public function __set($name, $value) {
		if ($name == 'where_clause' and is_array($value)) {
			$this->methods[] = 'where';
			$this->__where_clause[] = $value;
		}
	}

	/**
	 * Retrieving All Rows From A Table
	 */
	public function get(): DBCollection {
		return DBCollection::create($this->_get());
	}

	private function _get(): Generator {

		if (!$this->__isCustom) {
			if ($this->query_string == '') {
				$this->query_string = "SELECT * FROM `{$this->___table}` ";
			} elseif (strpos($this->query_string, 'select') === false) {
				$this->query_string = " SELECT * FROM `{$this->___table}` {$this->query_string}";
			}

			if (sizeof($this->__joins) > 0) {
				$tbl = str($this->_table)->replace('tbl', '')->toLower();
				$this->query_string .= " as $tbl ";
				foreach ($this->__joins as $joins) {
					$this->query_string .= $joins;
				}
			}
			if (sizeof($this->__where_clause) > 0) {
				$conditions = $this->___genWhere();
				$this->query_string .= " $conditions";
			}
			if (sizeof($this->__order_by) > 0) {
				$orderArray = [];
				foreach ($this->__order_by as $orderBy) {
					$orderArray[] = "ORDER BY $orderBy";
				}
				$orderArray = implode(',', $orderArray);
				$this->query_string .= " $orderArray";
			} elseif (sizeof($this->__groupBy) > 0) {
				$orderArray = [];
				foreach ($this->__order_by as $orderBy) {
					$orderArray[] = "GROUP BY $orderBy";
				}
				$orderArray = implode(',', $orderArray);
				$this->query_string .= " $orderArray";
			}
			if (sizeof($this->__having) > 0) {
				$conditions = $this->__genHaving();
				$this->query_string .= " $conditions";
			}
			if (sizeof($this->__limit) > 0) {
				$limit = end($this->__limit);
				$this->query_string .= " LIMIT $limit";
			}
			if (sizeof($this->__offset) > 0) {
				$offset = end($this->__offset);
				$this->query_string .= " OFFSET $offset";
			}
		}
//        echo $this->query_string;
		return $this->__run();
	}

	private function ___genWhere(): string {
		$i = 0;
		$conditions = '';
		foreach ($this->__where_clause as $item) {
			$i++;
			if ($i == 1) $item['type'] = ' where ';
			$conditions .= " {$item['type']} {$item['string']}";
		}
		return $conditions;
	}

	private function __genHaving() {
		$i = 0;
		$conditions = '';
		foreach ($this->__having as $item) {
			$i++;
			if ($i == 1) $item['type'] = ' HAVING ';
			$conditions .= " {$item['type']} {$item['string']}";
		}
		return $conditions;
	}

	/**
	 * @return Generator
	 */
	private function __run(): Generator {

		$res = $this->conn->prepare($this->query_string);
		$res->execute();
		if ($this->___entity instanceof stdClass or $this->__isCustom) {
			while ($row = $res->fetchObject()) {
				yield $row;
			}
		} else {
			while ($row = $res->fetchObject(get_class($this->___entity))) {
				yield $row;
			}
		}
	}

	public function rowCount(): int {

		if (!$this->__isCustom) {
			$this->query_string = "SELECT COUNT(*) as cnt from {$this->___table}  {$this->___genWhere()}";
			if (sizeof($this->__limit) > 0) {
				$limit = end($this->__limit);
				$this->query_string .= " LIMIT $limit";
			}
			if (sizeof($this->__offset) > 0) {
				$offset = end($this->__offset);
				$this->query_string .= " OFFSET $offset";
			}
		}
		$res = $this->conn->prepare($this->query_string);
		$res->execute();
		return $res->fetchObject()->cnt;
	}
	public function sum(string $column) {
		return (int)array_sum($this->custom("SELECT * FROM `{$this->___table}` {$this->___genWhere()}")->get()->map(function ($item) use ($column){
			return $item->$column;
		})->all());

	}

	public function __call($name, $arguments) {
		$Str = new Str($name);
		switch ($name) {
			case $Str->includes('where_'):
				$Str->replace('where_', '');
				switch ($Str) {
					case $Str->includes('Is'):
						switch ($arguments[0]) {
							case is_array($arguments[0]):
								$this->_whereIn($Str->replace('Is', ''), $arguments[0]);
								break;
							default:
								$this->_whereEquals($Str->replace('Is', ''), $arguments[0]);
								break;
						}
						break;
					case $Str->includes('IsNot'):
						switch ($arguments[0]) {
							case is_array($arguments[0]):
								$this->_whereIn($Str->replace('IsNot', ''), $arguments[0]);
								break;
							default:
								$this->whereNotIn($Str->replace('IsNot', ''), $arguments[0]);
								break;
						}
						break;
					case $Str->includes('Like'):
						$this->whereLike($Str->replace('Like', $arguments[0]));
						break;
				}
		}
		return $this;
	}

	/**
	 * @param string $column
	 * @param array $arrayOfValues
	 * @param string $operator
	 */
	private function _whereIn(string $column, array $arrayOfValues, string $operator = 'in') {
		$arrayOfValues = "( " . implode(',', $arrayOfValues) . ' )';
		$this->where_clause = [
			'type'   => 'and',
			'string' => " `$column` $operator $arrayOfValues"
		];
	}

	/**
	 * @param string $func_get_arg
	 * @param string|int $func_get_arg1
	 */
	private function _whereEquals(string $func_get_arg, $func_get_arg1) {
		$this->_whereOperator($func_get_arg, '=', $func_get_arg1);
	}

	/**
	 * @param $func_get_arg
	 * @param string $func_get_arg1
	 * @param $func_get_arg2
	 * @param string $type
	 */
	private function _whereOperator($func_get_arg, string $func_get_arg1, $func_get_arg2, string $type = 'and') {
		if (is_numeric($func_get_arg2) and !str($func_get_arg2)->startsWith('0') and $func_get_arg1 != 'like') {
			$func_get_arg2 = ($func_get_arg2 === NULL ? "NULL" : "$func_get_arg2");
		} else {
			$func_get_arg2 = ($func_get_arg2 === NULL ? "NULL" : "'$func_get_arg2'");
		}
//        $func_get_arg = str($func_get_arg)->includes('.') ? $func_get_arg : `$func_get_arg`;
		$this->where_clause = [
			'type'   => $type,
			'string' => "$func_get_arg  $func_get_arg1 $func_get_arg2"
		];
	}

	/**
	 * @param string $column
	 * @param array $arrayOfValues
	 *
	 * @return $this
	 */
	public function whereNotIn(string $column, array $arrayOfValues) {
		$this->_whereIn($column, $arrayOfValues, ' not in ');
		return $this;
	}

	public function whereLike() {
		foreach (func_get_args() as $index => $arg) {
			if (is_array($arg)) {
				foreach ($arg as $key => $value) {
					$this->_whereOperator($key, 'like', $value);
				}
			} else {
				$this->_whereOperator($index, 'like', $arg);
			}
		}
		return $this;
	}

	public function whereIs(string $key) {
		$this->_whereOperator($key, 'is', NULL);
		return $this;
	}

	/**
	 * @return $this
	 */
	public function where(): self {
		$args = func_get_args();
		switch (sizeof($args)) {
			case 1:
				if (is_array($args[0])) {
					foreach ($args[0] as $key => $value) {
						$this->_whereEquals($key, $value);
					}
				} elseif (is_string($args[0])) {
					$this->where_clause = [
						'type'   => 'and',
						'string' => " {$args[0]} "
					];
				}
				break;
			case 2:
				$this->_whereEquals(func_get_arg(0), func_get_arg(1));
				break;
			case 3:
				$this->_whereOperator(func_get_arg(0), func_get_arg(1), func_get_arg(2));
				break;
			default:
				foreach (array_chunk($args, 3) as $item) {
					call_user_func_array([
						$this,
						'where'
					], $item);
				}
				break;
		}
		return $this;
	}

	/**
	 * @return $this
	 */
	public function orWhere(): self {
		$args = func_get_args();
		switch (sizeof($args)) {
			case 1:
				if (is_array($args[0])) {
					foreach ($args[0] as $key => $value) {
						$this->_orWhereEquals($key, $value);
					}
				} else if (is_string($args[0])) {
					$this->where_clause = [
						'type'   => 'or',
						'string' => " $args[0]"
					];
				}
				break;
			case 2:
				$this->_orWhereEquals(func_get_arg(0), func_get_arg(1));
				break;
			case 3:
				$this->_whereOperator(func_get_arg(0), func_get_arg(1), func_get_arg(2), 'or');
				break;
		}
		return $this;
	}

	/**
	 * @param string $func_get_arg
	 * @param string $func_get_arg1
	 */
	private function _orWhereEquals(string $func_get_arg, string $func_get_arg1) {
		$this->_orWhereOperator($func_get_arg, '=', $func_get_arg1);
	}

	/**
	 * @param $func_get_arg
	 * @param string $func_get_arg1
	 * @param $func_get_arg2
	 */
	private function _orWhereOperator($func_get_arg, string $func_get_arg1, $func_get_arg2) {
		$func_get_arg = str($func_get_arg)->includes('.') ? $func_get_arg : `$func_get_arg`;

		$this->where_clause = [
			'type'   => 'or',
			'string' => " `$func_get_arg` $func_get_arg1 '$func_get_arg2'"
		];
	}

	/**
	 * @param string $column
	 * @param int $min
	 * @param int $max
	 *
	 * @return $this
	 */
	public function whereBetween(string $column, int $min, int $max) {
		$this->_whereRange($column, $min, $max, 'between');
		return $this;
	}

	/**
	 * @param string $column
	 * @param int $min
	 * @param int $max
	 * @param string $string
	 */
	private function _whereRange(string $column, int $min, int $max, string $string) {
		$condition = '1 = 1';
		if ($string == 'between') {
			$condition = "`$column` >= $min and `$column` <= $max";
		} elseif ($string == 'not_between') {
			$condition = "`$column` <= $min or `$column` >= $max";
		}
		$this->where_clause = [
			'type'   => 'and',
			'string' => " $condition"
		];
	}

	/**
	 * @param string $column
	 * @param int $min
	 * @param int $max
	 *
	 * @return $this
	 */
	public function whereNotBetween(string $column, int $min, int $max): self {
		$this->_whereRange($column, $min, $max, 'not_between');
		return $this;
	}

	/**
	 * @param int $offset
	 *
	 * @return $this
	 */
	public function offset(int $offset): self {
		$this->__offset[] = " $offset";
		return $this;
	}

	/**
	 * @param int $limit
	 *
	 * @return $this
	 */
	public function limit(int $limit): self {
		if ($limit > 0) {
			$this->__limit[] = " $limit";
		}
		return $this;
	}

	/**
	 * @param string $column
	 * @param bool $desc
	 *
	 * @return $this
	 */
	public function orderBy(string $column = '', bool $desc = false): self {
		$desc = $desc ? "DESC" : '';
		$column = ($column != '' ? "`$column`" : 'RAND()');
		$this->__order_by[] = " $column $desc";
		return $this;
	}

	/**
	 * @param string $column
	 *
	 * @return $this
	 */
	public function groupBy(string $column) {
		$this->__groupBy[] = $column;
		return $this;
	}

	/**
	 * @param string $column
	 * @param string $operator
	 * @param $value
	 *
	 * @return $this
	 */
	public function having(string $column, string $operator, $value) {
		$this->__having[] = " `$column` $operator $value";
		return $this;
	}

	/**
	 * @param string $column
	 * @param array $arrayOfValues
	 *
	 * @return $this
	 */
	public function whereIn(string $column, array $arrayOfValues) {
		if (sizeof($arrayOfValues) <= 1) {
			if (!isset($arrayOfValues[0])){
				$arrayOfValues[] = 0;
			}
			$this->_whereEquals($column, "$arrayOfValues[0]");
		} else {
			$this->_whereIn($column, $arrayOfValues, ' in ');
		}
		return $this;
	}

	public function insert(array $colsAndValue) {
		switch (CountDimensions($colsAndValue)) {
			case 1:
				[
					$fields,
					$values
				] = $this->_insert($colsAndValue);
				$this->query_string = "INSERT INTO `{$this->___table}` ($fields) VALUES ($values)";
				return $this->__runBool();
			case 2:
				$i = 0;
				foreach ($colsAndValue as $item) {
					[
						$fields,
						$values
					] = $this->_insert($item);
					$this->query_string = "INSERT INTO `{$this->___table}` ($fields) VALUES ($values)";
					if ($this->__runBool()) {
						$i++;
					}
				}
				return $i;
		}
	}

	private function _insert(array $info) {
		$fields = "";
		$values = "";
		foreach ($info as $key => $value) {
			$value = str_replace('\\', '\\\\', $value);
			$fields .= " `$key`,";
			$values .= "'$value',";
		}
		$fields = substr($fields, 0, strlen($fields) - 1);
		$values = substr($values, 0, strlen($values) - 1);
		return [
			$fields,
			$values
		];
	}

	/**
	 * @return bool
	 */
	private function __runBool(): bool {
//		echo $this->showQuery();
		$res = $this->conn->prepare($this->query_string);
		$res->execute();
		return $res->errorInfo()[0] === '00000';
	}

	public function showQuery() {
		if ($this->__type == 'select') {
			$this->_get();
		}
		return "<kbd>{$this->query_string}</kbd>";
	}

	public function update(array $array): bool {
		$this->query_string = "UPDATE `{$this->___table}` SET {$this->_update($array)} {$this->___genWhere()}";
		$this->__type = 'update';
//        echo $this->showQuery();
		return $this->__runBool();
	}

	private function _update(array $array) {
		$fields = "";
		foreach ($array as $field => $value) {
			$value = str_replace('\\', '\\\\', $value);
			if (is_int($value)) {
				$fields .= " `$field` = $value ,";
			} else {
				$fields .= " `$field` = '$value' ,";
			}
		}
		return substr($fields, 0, strlen($fields) - 1);
	}

	/**
	 * @param array $colsAndValue
	 *
	 * @return int
	 */
	public function insertWithId(array $colsAndValue): int {
		[
			$fields,
			$values
		] = $this->_insert($colsAndValue);
		$this->__type = 'insert';
		$this->query_string = "INSERT INTO `{$this->___table}` ($fields) VALUES ($values)";
		if ($this->__runBool()) {
			return (int)$this->conn->lastInsertId();
		} else {
			return 0;
		}
	}

	public function delete(): bool {
		$this->query_string = "DELETE FROM `{$this->___table}` {$this->___genWhere()}";
		$this->__type = 'delete';
		return $this->__runBool();
	}

	public function custom(string $string) {
		$string = str($string);
		$string->replace("^table^", $this->_table);
		$string->replace("^key^", $this->_key);
		$this->query_string = $string;
		$this->__isCustom = true;
		return $this;
	}

	public function leftJoin(Model $instance, string $foreign_key = 'primary_key', string $primary_key = 'primary_key'): self {
		$foreign_id = $foreign_key == 'primary_key' ? $instance->_key : $foreign_key;
		$primary_id = $primary_key == 'primary_key' ? $instance->_key : $primary_key;
		$tblLeft = str($this->_table)->replace('tbl', '')->toLower();
		$tblRight = str($instance->_table)->replace('tbl', '')->toLower();
		$this->__joins[] = " LEFT JOIN $instance->_table as $tblRight on $tblLeft.$foreign_id = $tblRight.$primary_id";
		return $this;
	}

	private function lastMethod() {
		return $this->methods[sizeof($this->methods) - 1];
	}

}
