<?php

namespace model\Entity;

use DATABASE\ORM\Interact\Entities\EntityScheme;
use FwHtml\Elements\Tags\Main\HtmlTags;
use FwHtml\Elements\Tags\Option;
use model\Artists;
use model\AudioBookEpisodes;
use model\Labels;

class AudioBooksEntity extends EntityScheme {
	public $audio_book_id;
	/**
	 * نام کتاب
	 **/
	public $book_name;
	/**
	 * انتخاب هنرمند
	 **/
	public $artist_id;
	/**
	 * کاور کتاب
	 **/
	public $book_cover;
	/**
	 * انتخاب برچسب ها
	 **/
	public $label_ids;
	/**
	 * پایان یافته
	 **/
	public $is_ended;
	/**
	 * کتاب روزانه
	 **/
	public $is_daily;
	/**
	 * اشتراک مورد نیاز
	 **/
	public $membership_id;
	/**
	 * تاریخ شروع
	 **/
	public $book_start_date;

	public function model() {
		return new \model\AudioBooks();
	}

	public function toOption(): Option {
		return HtmlTags::Option()->Value($this->audio_book_id)->Content($this->book_name);
	}

	public function singleApiFormat($isBookmarked = false, $hasAccess = true, $userId = 0): array {
		$labels = Labels::Db()->whereIn('label_id', json_decode($this->label_ids, true) ?? [])->get()->map(function (LabelsEntity $label) {
			return $label->apiFormat();
		})->values();
		$artist = Artists::get($this->artist_id);
		return [
			'id'           => $this->audio_book_id,
			'name'         => $this->book_name,
			'cover'        => $this->book_cover ? __IMAGES__ . "AudioBooks/" . $this->book_cover : null,
			'labels'       => $labels,
			'startDate'    => (int)$this->book_start_date,
			'isEnded'      => $this->is_ended == 1,
			'lastEpisode'  => null,
			'comingNumber' => 0,
			'artist'       => $artist instanceof ArtistsEntity ? $artist->apiFormat() : null,

			'episodeCount' => AudioBookEpisodes::Db()->where('audio_book_id', $this->audio_book_id)->rowCount(),
			'episodes'     => AudioBookEpisodes::Db()->where('audio_book_id', $this->audio_book_id)->orderBy('episode_number', false)->get()->map(function (AudioBookEpisodesEntity $episodesEntity) use ($hasAccess, $userId) {
				return $episodesEntity->apiFormat($hasAccess, $userId);
			})->values()->sortBy('number', false),
			'isBookmarked' => $isBookmarked,
		];
	}

	public function apiFormat(?AudioBookEpisodesEntity $lastEpisode = null, $isBookmarked = false): array {
		$labels = Labels::Db()->whereIn('label_id', json_decode($this->label_ids, true) ?? [])->get()->map(function (LabelsEntity $label) {
			return $label->apiFormat();
		})->values();
		$artist = Artists::get($this->artist_id);

		return [
			'id'              => $this->audio_book_id,
			'name'            => $this->book_name,
			'cover'           => $this->book_cover ? __IMAGES__ . "AudioBooks/" . $this->book_cover : null,
			'labels'          => $labels,
			'startDate'       => (int)$this->book_start_date,
			'isEnded'         => $this->is_ended == 0,
			'episodeCount'    => AudioBookEpisodes::Db()->where('audio_book_id', $this->audio_book_id)->rowCount(),
			'lastEpisode'     => $lastEpisode instanceof AudioBookEpisodesEntity ? $lastEpisode->apiFormat() : null,
			'artist'          => $artist instanceof ArtistsEntity ? $artist->apiFormat() : null,
			'comingNumber'    => (int)($lastEpisode instanceof AudioBookEpisodesEntity ? $lastEpisode->episode_number : AudioBookEpisodes::Db()->where('audio_book_id', $this->audio_book_id)->orderBy('episode_number', true)->limit(1)->get()->first->episode_number ?? 0),
			'episodes'        => [],
			'isBookmarked'    => $isBookmarked,
			'isLastPublished' => $this->is_ended == 0,
		];
	}

	protected function dictionary(): array {
		return [
			'audio_book_id'   => 'audio_book_id',
			'book_name'       => 'audio_book_name',
			'artist_id'       => 'artist_id',
			'book_cover'      => 'audio_book_cover',
			'label_ids'       => 'label_ids',
			'is_ended'        => 'is_ended',
			'is_daily'        => 'is_daily',
			'membership_id'   => 'membership_id',
			'book_start_date' => 'audio_book_start_date',
		];
	}
}
