<?php

namespace model\Entity;

use DATABASE\ORM\Interact\Entities\EntityScheme;

class EventsEntity extends EntityScheme {
	public $event_id;
	public $user_id;
	public $name;
	public $cover;
	public $location;
	public $datetime;
	public $capacity;
	public $notes;
	public $text;
	public $entry_price;

	public function model() {
		return new \model\Events();
	}

	public function apiFormat(): array {
		return [
			'id'       => $this->event_id,
			'name'     => $this->name,
			'cover'    => __IMAGES__ . 'Events/' . $this->cover,
			'location' => $this->location,
			'datetime' => jdate("Y/m/d  H:i",$this->datetime),
			'capacity' => $this->capacity,
			'notes'    => $this->notes,
			'text'     => $this->text,
			'price'    => $this->entry_price,
		];
	}

	protected function dictionary(): array {
		return [
			'event_id'    => 'event_id',
			'user_id'     => 'user_id',
			'name'        => 'event_name',
			'cover'       => 'event_cover',
			'location'    => 'event_location',
			'datetime'    => 'event_datetime',
			'capacity'    => 'event_capacity',
			'notes'       => 'event_notes',
			'text'        => 'event_text',
			'entry_price' => 'event_entry_price',
		];
	}
}
