<?php

namespace model\Entity;

use DATABASE\ORM\Interact\Entities\EntityScheme;

class NewsEntity extends EntityScheme {
	public $news_id;
	/**
	 * عنوان
	 **/
	public $title;
	public $summary;
	/**
	 * کاور
	 **/
	public $cover;
	/**
	 * متن
	 **/
	public $text;

	public function model() {
		return new \model\News();
	}

	public function apiFormat(): array {
		return [
			'id'      => $this->news_id,
			'title'   => $this->title,
			'summary' => $this->summary,
			'cover'   => __IMAGES__ . 'News/' . $this->cover,
			'text'    => $this->text,
			'date'    => jdate("Y/m/d", strtotime($this->created_at)),
		];
	}

	protected function dictionary(): array {
		return [
			'news_id' => 'news_id',
			'title'   => 'news_title',
			'summary' => 'news_summary',
			'cover'   => 'news_cover',
			'text'    => 'news_text',
		];
	}
}
