<?php

namespace model\Entity;

use DATABASE\ORM\Interact\Entities\EntityScheme;
use FwHtml\Elements\Tags\Option;
use model\Rewards;

class RewardCategoriesEntity extends EntityScheme {
	public $reward_category_id;
	/**
	 * دسته بندی
	 **/
	public $category_name;
	/**
	 * آیکون
	 **/
	public $category_icon;

	public function model() {
		return new \model\RewardCategories();
	}

	public function toOption(): Option {
		return parent::__toOption('category_name'); // TODO: Change the autogenerated stub
	}

	public function apiFormat(): array {
		$rewards = Rewards::Db()->where('reward_category_id', $this->reward_category_id)->get()->map(function (RewardsEntity $rewardsEntity) {
			return $rewardsEntity->apiFormat();
		})->values();
		return [
			'id'      => $this->reward_category_id,
			'name'    => $this->category_name,
			'icon'    => __IMAGES__ . 'RewardCategories/' . $this->category_icon,
			'rewards' => $rewards,
		];
	}

	protected function dictionary(): array {
		return [
			'reward_category_id' => 'reward_category_id',
			'category_name'      => 'reward_category_name',
			'category_icon'      => 'reward_category_icon',
		];
	}
}
