<?php

namespace model\Entity;

use DATABASE\ORM\Interact\Entities\EntityScheme;
use model\PoemCategories;
use model\Poems;

class PoemCategoriesEntity extends EntityScheme {
	public $poem_category_id;
	/**
	 * انتخاب شاعر
	 **/
	public $poet_id;
	/**
	 * نام دسته بندی
	 **/
	public $name;
	/**
	 * دسته بندی مادر
	 **/
	public $parent_id;

	public function model() {
		return new \model\PoemCategories();
	}

	public function apiFormat(): array {
		$subCategoryCount = PoemCategories::Db()->where('parent_id', $this->poem_category_id)->rowCount();
		$poemCount = Poems::Db()->where('poem_category_id', $this->poem_category_id)->rowCount();
		return [
			'id'               => $this->poem_category_id,
			'name'             => $this->name,
			'subCategoryCount' => $subCategoryCount,
			'poemCount'        => $poemCount,
		];
	}

	protected function dictionary(): array {
		return [
			'poem_category_id' => 'poem_category_id',
			'poet_id'          => 'poet_id',
			'name'             => 'poem_category_name',
			'parent_id'        => 'parent_id',
		];
	}
}
