<?php

namespace model\Entity;

use DATABASE\ORM\Interact\Entities\EntityScheme;

class PoemThemesEntity extends EntityScheme {
	public $poem_theme_id;
	/**
	 * عنوان
	 **/
	public $name;
	/**
	 * توضیحات
	 **/
	public $theme_details;

	public function model() {
		return new \model\PoemThemes();
	}

	public function apiFormat(): array {
		return [
			'id'      => $this->poem_theme_id,
			'name'    => $this->name,
			'details' => $this->theme_details,
		];
	}

	protected function dictionary(): array {
		return [
			'poem_theme_id' => 'poem_theme_id',
			'name'          => 'poem_theme_name',
			'theme_details' => 'poem_theme_details',
		];
	}
}
