<?php

namespace model\Entity;

use DATABASE\ORM\Interact\Entities\EntityScheme;
use model\PoemLanguages;
use model\PoeticForms;
use model\PoeticMeters;

class PoemsEntity extends EntityScheme {
	public $poem_id;
	/**
	 * نام شعر
	 **/
	public $name;
	/**
	 * شاعر
	 **/
	public $poet_id;
	/**
	 * دسته بندی شعر
	 **/
	public $category_id;
	/**
	 * زبان شعر
	 **/
	public $language_id;
	/**
	 * قالب شعر
	 **/
	public $poetic_form_id;
	/**
	 * وزن شعر
	 **/
	public $poetic_meter_id;
	/**
	 * متن شعر
	 **/
	public $text;

	public function model() {
		return new \model\Poems();
	}

	public function singleFormat(): array {
		/** @var PoemLanguagesEntity $language */
		$language = PoemLanguages::get($this->language_id);
		/** @var PoeticFormsEntity $form */
		$form = PoeticForms::get($this->poetic_form_id);
		/** @var PoeticMetersEntity $meter */
		$meter = PoeticMeters::get($this->poetic_meter_id);

		return [
			'id'       => $this->poem_id,
			'language' => $language->apiFormat(),
			'form'     => $form instanceof PoeticFormsEntity ? $form->apiFormat() : null,
			'meter'    => $meter instanceof PoeticMetersEntity ? $meter->apiFormat() : null,
			'name'     => $this->name,
			'text'     => $this->text,
		];
	}

	public function apiFormat(): array {
		return [
			'id'   => $this->poem_id,
			'name' => $this->name,
			'text' => $this->text,
		];
	}

	protected function dictionary(): array {
		return [
			'poem_id'         => 'poem_id',
			'name'            => 'poem_name',
			'poet_id'         => 'poet_id',
			'category_id'     => 'poem_category_id',
			'language_id'     => 'poem_language_id',
			'poetic_form_id'  => 'poetic_form_id',
			'poetic_meter_id' => 'poetic_meter_id',
			'text'            => 'poem_text',
		];
	}
}
