<?php

namespace model\Entity;

use DATABASE\ORM\Interact\Entities\EntityScheme;
use FwHtml\Elements\Tags\Main\HtmlTags;
use FwHtml\Elements\Tags\Option;

class PoeticMetersEntity extends EntityScheme {
	public $poetic_meter_id;
	/**
	 * نام وزن
	 **/
	public $name;

	public function model() {
		return new \model\PoeticMeters();
	}

	public function toOption(): Option {
		return HtmlTags::Option()->Value($this->poetic_meter_id)->Content($this->name);
	}

	public function apiFormat(): array {
		return [
			'id'   => $this->poetic_meter_id,
			'name' => $this->name,
		];
	}

	protected function dictionary(): array {
		return [
			'poetic_meter_id' => 'poetic_meter_id',
			'name'            => 'poetic_meter_name',
		];
	}
}
