<?php

namespace model\Entity;

use DATABASE\ORM\Interact\Entities\EntityScheme;
use model\Locations;
use model\PoemThemes;
use model\PoeticStyles;

class PoetsEntity extends EntityScheme {
	public $poet_id;
	/**
	 * نام شاعر
	 **/
	public $name;
	/**
	 * قرن
	 **/
	public $time_period_id;
	/**
	 * سبک شعری
	 **/
	public $poetic_style_id;
	/**
	 * موضوع اشعار
	 **/
	public $poem_theme_id;
	/**
	 * منطقه جغرافیایی
	 **/
	public $location_id;
	/**
	 * تصویر شاعر
	 **/
	public $image;
	/**
	 * بیوگرافی
	 **/
	public $bio;

	public function model() {
		return new \model\Poets();
	}

	public function apiFormat(): array {

		$location = Locations::get($this->location_id);
		$styles = json_decode($this->poetic_style_id, true);
		$themes = json_decode($this->poem_theme_id, true);
		$poeticStyles = [];
		$poeticThemes = [];
		if (is_array($styles)) {
			$poeticStyles = PoeticStyles::Db()->whereIn('poetic_style_id', $styles)->get()->map(function (PoeticStylesEntity $style) {
				return $style->apiFormat();
			})->values();
		}
		if (is_array($themes)) {
			$poeticThemes = PoemThemes::Db()->whereIn('poem_theme_id', $themes)->get()->map(function (PoemThemesEntity $theme) {
				return $theme->apiFormat();
			})->values();
		}
		return [
			'id'           => $this->poet_id,
			'name'         => $this->name,
			'image'        => startsWith($this->image, 'http') ? $this->image : __IMAGES__ . 'Poets/' . $this->image,
			'bio'          => $this->bio,
			'styles' => $poeticStyles,
			'themes' => $poeticThemes,
		];
	}

	protected function dictionary(): array {
		return [
			'poet_id'         => 'poet_id',
			'name'            => 'poet_name',
			'time_period_id'  => 'time_period_id',
			'poetic_style_id' => 'poetic_style_id',
			'poem_theme_id'   => 'poem_theme_id',
			'location_id'     => 'location_id',
			'image'           => 'poet_image',
			'bio'             => 'poet_bio',
		];
	}
}
