<?php

namespace model\Entity;

use DATABASE\ORM\Interact\Entities\EntityScheme;
use model\Artists;
use model\Comments;
use model\Episodes;
use model\Labels;
use model\Likes;
use model\Views;

class StoriesEntity extends EntityScheme {
	public $story_id;
	/**
	 * نام داستان
	 **/
	public $name;
	/**
	 * کاور
	 **/
	public $cover;
	/**
	 * برچسب ها
	 **/
	public $label_ids;
	/**
	 * تاریخ شروع داستان
	 **/
	public $start_date;
	/**
	 * وضعیت داستان
	 **/
	public $is_ended;
	/**
	 * انتخاب پلن
	 **/
	public $plan_id;
	public $summary;

	public function model() {
		return new \model\Stories();
	}

	public function singleApiFormat($isBookmarked = false, bool $hasAccess = true, $userId = 0): array {
		$labels = Labels::Db()->whereIn('label_id', json_decode($this->label_ids, true) ?? [])->get()->map(function (LabelsEntity $label) {
			return $label->apiFormat();
		})->values();
		$artist = Artists::get($this->artist_id);

		$comments = Comments::Db()->where('story_id', $this->story_id)->where('status', 1)->get()->map(function (CommentsEntity $commentsEntity) {
			return $commentsEntity->apiFormat();
		})->values();

		$likes = Likes::Db()->where([
			'story_id' => $this->story_id,
		])->rowCount();
		$comments = Comments::Db()->where([
			'story_id' => $this->story_id,
		])->rowCount();
		$views = Views::Db()->where([
			'story_id'     => $this->story_id,
		])->rowCount();
		return [
			'id'           => $this->story_id,
			'name'         => $this->name,
			'cover'        => $this->cover ? __IMAGES__ . "Stories/" . $this->cover : null,
			'labels'       => $labels,
			'startDate'    => (int)$this->start_date,
			'summary'      => $this->summary ?? "",
			'isEnded'      => $this->is_ended == 1,
			'lastEpisode'  => null,
			'comingNumber' => 0,
			'episodeCount' => Episodes::Db()->where('story_id', $this->story_id)->rowCount(),
			'episodes'     => Episodes::Db()->where('story_id', $this->story_id)->orderBy('episode_number', false)->get()->map(function (EpisodesEntity $episodesEntity) use ($hasAccess, $userId) {
				return $episodesEntity->apiFormat($hasAccess, $userId);
			})->values(),
			'isBookmarked' => $isBookmarked,
			'artist'       => $artist instanceof ArtistsEntity ? $artist->apiFormat() : null,
			'comments'     => $comments,
			'likes'        => $likes,
			'views'        => $views,

		];
	}

	public function apiFormat(?EpisodesEntity $lastEpisode = null, $isBookmarked = false): array {
		$labels = Labels::Db()->whereIn('label_id', json_decode($this->label_ids, true) ?? [])->get()->map(function (LabelsEntity $label) {
			return $label->apiFormat();
		})->values();

		$likes = Likes::Db()->where([
			'story_id' => $this->story_id,
		])->rowCount();
		$comments = Comments::Db()->where([
			'story_id' => $this->story_id,
		])->rowCount();
		$views = Views::Db()->where([
			'story_id'     => $this->story_id,
		])->rowCount();
		return [
			'id'      => $this->story_id,
			'name'    => $this->name,
			'summary' => "",

			'cover'           => $this->cover ? __IMAGES__ . "Stories/" . $this->cover : null,
			'labels'          => $labels,
			'startDate'       => (int)$this->start_date,
			'isEnded'         => $this->is_ended == 0,
			'episodeCount'    => Episodes::Db()->where('story_id', $this->story_id)->rowCount(),
			'lastEpisode'     => $lastEpisode instanceof EpisodesEntity ? $lastEpisode->apiFormat() : null,
			'comingNumber'    => (int)($lastEpisode instanceof EpisodesEntity ? $lastEpisode->number : Episodes::Db()->where('story_id', $this->story_id)->orderBy('episode_number', true)->limit(1)->get()->first->episode_number ?? 0),
			'episodes'        => [],
			'isBookmarked'    => $isBookmarked,
			'isLastPublished' => $this->is_ended == 0,
			'likes'           => $likes,
			'comments'        => $comments,
			'views'           => $views,
		];
	}

	protected function dictionary(): array {
		return [
			'story_id'   => 'story_id',
			'name'       => 'story_name',
			'cover'      => 'story_cover',
			'label_ids'  => 'label_ids',
			'start_date' => 'story_start_date',
			'is_ended'   => 'is_ended',
			'plan_id'    => 'plan_id',
		];
	}
}
