<div class="content-header">
    <div class="container-fluid">
        <div class="row mb-2">
            <div class="col-sm-6 d-flex">
                <h1 class="m-0 text-dark">خوش آمدید!</h1>

            </div>
            <div class="col-sm-6">
                <ol class="breadcrumb float-sm-left">
                    <li class="breadcrumb-item"><a href="#">خانه</a></li>
                    <li class="breadcrumb-item active">داشبورد مدیریتی</li>
                </ol>
            </div>
        </div>
        <div class="row">
			<?php

			use DATABASE\ORM\QueryBuilder\QueryBuilder\Db;
			use FwHtml\Elements\Tags\Main\HtmlTags;
			use model\PaymentTable;
			use model\Users;

			function addCard(string $showNumber, string $nameFiled, string $link, string $id, string $color, int $size = 4) {
				echo HtmlTags::Div(".col-lg-$size.col-12")->Content(
					HtmlTags::Div('.small-box.' . $color . '')->Content(
						HtmlTags::Div('.inner.text-center')->Content(
							HtmlTags::H5($showNumber),
							HtmlTags::P($nameFiled)
						),
					)
				);
			}

			$inActiveCount = Users::Db()->where('membership_id', '=', 0)->rowCount();
			$planAmount = PaymentTable::Db()->where('payment_status', 1)->where('payment_type', 'like', '%buyPlan%')->sum('payment_amount') / 10;
			$activeCount = Users::Db()->where('membership_id', '>', 0)->where('membership_expired_at', '>', time())->rowCount();


			addCard(price_format(PaymentTable::Db()->where('payment_status', 1)->where('payment_type', 'like', '%buyPlan%')->where('payment_date', '>', strtotime("today") - 1)->sum('payment_amount') / 10), 'مجموع خرید اشتراک امروز', '', '', 'border.border-success');
			addCard(Users::Db()->where("created_at", '>=', date("Y-m-d H:i:s", strtotime('today')))->rowCount(), 'ثبت نام جدید (امروز)', '', '', 'border.border-success');
			addCard(price_format(PaymentTable::Db()->where('payment_status', 1)->where('payment_type', 'like', '%buyPlan%')->where('payment_date', '>', strtotime("yesterday") - 1)->where('payment_date', '<=', strtotime("today") - 1)->sum('payment_amount') / 10), 'مجموع خرید اشتراک دیروز', '', '', 'border.border-success');
			addCard(PaymentTable::Db()->where('payment_status', 1)->where('payment_type', 'like', '%buyPlan%')->where('payment_date', '>', strtotime("today") - 1)->rowCount() . ' نفر', 'تعداد خرید اشتراک امروز', '', '', 'border.border-success');
			addCard(Users::Db()->where('membership_id', '>', 0)->where('membership_expired_at', '<=', time())->rowCount(), 'اشتراک های منقضی شده', '', '', 'border.border-danger');
			addCard(PaymentTable::Db()->where('payment_status', 1)->where('payment_type', 'like', '%buyPlan%')->where('payment_date', '>', strtotime("yesterday") - 1)->where('payment_date', '<=', strtotime("today") - 1)->rowCount() . ' نفر', 'تعداد خرید اشتراک دیروز', '', '', 'border.border-success');

			$audioBookUse = Db::table('tblAudioBookUse')->get()->map(function ($item) {
				$payment = PaymentTable::Db()->where([
					'user_id'        => $item->user_id,
					'payment_status' => 1
				])->orderBy('payment_sdate', true)->get();
				if ($payment->length() > 0) {
					return $payment->first->payment_amount / 10;
				}
				return 0;
			})->values();
			addCard(price_format(array_sum($audioBookUse->all()) * 0.2), 'صندوق صوتی ها', '', '', 'border.border-warning');
			addCard(price_format(array_sum($audioBookUse->all())), 'مجموع خرید اشتراک صوتی ها', '', '', 'border.border-warning');
			addCard(price_format($planAmount - array_sum($audioBookUse->all())), 'خرید اشتراک با کسر صوتی ها', '', '', 'border.border-info');
			addCard(price_format(($planAmount - array_sum($audioBookUse->all())) / 2 + (array_sum($audioBookUse->all()) * 0.4)), 'سهم کل اپلیکیشن', '', '', 'bg-success');
			addCard(price_format(array_sum($audioBookUse->all()) * 0.4), 'سهم خانم افشاری', '', '', 'bg-success');
			addCard(price_format(($planAmount - array_sum($audioBookUse->all())) / 2), 'سهم نویسنده', '', '', 'bg-success');
			addCard(Users::Db()->rowCount(), 'کل کاربران', '', '', 'border.border-info');
			addCard($inActiveCount, 'کاربران بدون اشتراک', '', '', 'bg-info');
			addCard(Users::Db()->where('membership_id', '>', 0)->rowCount(), 'کاربران با اشتراک', '', '', 'border.border-info');
			addCard(price_format(PaymentTable::Db()->where('payment_status', 1)->sum('payment_amount') / 10), 'مجموع کل پرداخت ها', '', '', 'border.border-success');
			addCard(price_format(PaymentTable::Db()->where('payment_status', 1)->where('payment_type', 'buyBooks')->sum('payment_amount') / 10), 'مجموع پرداخت های کتاب', '', '', 'border.border-info');
			addCard(price_format($planAmount), 'مجموع پرداخت های اشتراک', '', '', 'border.border-success');
			addCard(price_format(($planAmount / $activeCount) * $inActiveCount), 'پتانسیل درآمد', '', '', 'bg-warning', 12);

			?>
        </div>

    </div>
</div>

