<?php

use controller\Files;
use controller\Users;
use FwAuthSystem\Main\UserObject;
use FwHtml\FontAwesome as Fa;

$SideBar = new Sidebar(true);
$SideBar->Item("مدیریت اپلیکیشن", Fa::Mobile())->_items([
	MenuItem::create('فایل منیجر', Fa::Stack_exchange())->LinksTo(Files::class),
	MenuItem::create('صفحات ورودی', Fa::Stack_exchange())->LinksTo(\controller\Onboardings::class),
	MenuItem::create('هنرمندان', Fa::Paint_brush())->LinksTo(\controller\Artists::class),
	MenuItem::create('تنظیمات', Fa::Wrench())->LinksTo(\controller\Settings::class),
	MenuItem::create('امتیاز ها', Fa::Wrench())->LinksTo(\controller\Points::class),
	MenuItem::create('سیستم امتیازدهی', Fa::Wrench())->LinksTo(\controller\Scores::class),
]);
$SideBar->Item("مدیریت داستان ها", Fa::Book())->_items([
    MenuItem::create('داستان ها', Fa::Bookmark())->LinksTo(\controller\Stories::class),
	MenuItem::create('برچسب ها', Fa::Stack_exchange())->LinksTo(\controller\Labels::class),
    MenuItem::create('اپیزود ها', Fa::Bookmark())->LinksTo(\controller\Episodes::class),
]);
$SideBar->Item("مدیریت کتاب ها", Fa::Book())->_items([
	MenuItem::create('برچسب ها', Fa::Stack_exchange())->LinksTo(\controller\Labels::class),
    MenuItem::create('کتاب ها', Fa::Bookmark())->LinksTo(\controller\Books::class),
    MenuItem::create('سفارشات', Fa::Bookmark())->LinksTo(\controller\Orders::class),
]);

$SideBar->Item("مدیریت اشعار", Fa::Pencil())->_items([
	MenuItem::create('مناطق جعرافیایی', Fa::Map())->LinksTo(\controller\Locations::class),
    MenuItem::create('دسته بندی شعر', Fa::Stack_exchange())->LinksTo(\controller\PoemCategories::class),
    MenuItem::create('زبان', Fa::Microphone())->LinksTo(\controller\PoemLanguages::class),
    MenuItem::create('اشعار', Fa::Pencil())->LinksTo(\controller\Poems::class),
    MenuItem::create('موضوع شعر', Fa::Stack_exchange())->LinksTo(\controller\PoemThemes::class),
    MenuItem::create('قالب شعر', Fa::Stack_exchange())->LinksTo(\controller\PoeticForms::class),
    MenuItem::create('وزن شعر', Fa::Stack_exchange())->LinksTo(\controller\PoeticMeters::class),
    MenuItem::create('سبک شعر', Fa::Stack_exchange())->LinksTo(\controller\PoeticStyles::class),
    MenuItem::create('شعرا', Fa::Stack_exchange())->LinksTo(\controller\Poets::class),
    MenuItem::create('قرن ها', Fa::Stack_exchange())->LinksTo(\controller\TimePeriods::class),
]);

$SideBar->Item("مدیریت کاربران", Fa::Users())->_items([
	MenuItem::create('کاربران', Fa::User())->LinksTo(Users::class),
	MenuItem::create('کد های تایید', Fa::User())->LinksTo(\controller\UserTemps::class),
	MenuItem::create('آدرس ها', Fa::User())->LinksTo(\controller\UserAddresses::class),
	MenuItem::create('پلن های عضویت', Fa::User())->LinksTo(\controller\Memberships::class),
	MenuItem::create('نظرات', Fa::User())->LinksTo(\controller\Comments::class),
    MenuItem::create('نوتیفیکیشن ها', Fa::Envelope())->LinksTo(\controller\Notifications::class),
    MenuItem::create('کد های تخفیف', Fa::Percent())->LinksTo(\controller\Discounts::class),
    MenuItem::create('دعوت شدگان', Fa::Envelope_square())->LinksTo(\controller\Referrals::class),
]);
$SideBar->Item("مدیریت کتاب های صوتی", Fa::Audio_description())->_items([
	MenuItem::create('کتاب هاب صونی', Fa::File_audio_o())->LinksTo(\controller\AudioBooks::class),
	MenuItem::create('اپیزود ها', Fa::Bookmark())->LinksTo(\controller\AudioBookEpisodes::class),
]);
$SideBar->Item('رویداد ها', Fa::Fire())->LinksTo(\controller\Events::class);
$SideBar->Item('تایید مدارک', Fa::Check_circle())->LinksTo(\controller\Users::RelPath([],'confirmDocs'));



$SideBar->Item("گزارشات", Fa::Area_chart())->_items([
    MenuItem::create('گزارش فروش', Fa::Line_chart())->LinksTo(\controller\SaleReports::class),
    MenuItem::create('کارت به کارت ها', Fa::Envelope())->LinksTo(\controller\Users::RelPath([],'cardPayments')),
    MenuItem::create('ارز دیجیتال', Fa::Envelope())->LinksTo(\controller\Users::RelPath([],'cryptoPayments')),
    MenuItem::create('پلن های عضویت کاربران', Fa::Envelope())->LinksTo(\controller\UserMemberships::class),

]);

if (UserObject::RoleName() == 'DeveloperRole') {
	$SideBar->Item('Tools', Fa::Wrench())->_items([
		MenuItem::create('QUERY BUILDER', Fa::Times_circle_o())
			->LinksTo('QueryBuilder/QueryBuilder.fwTools'),
		MenuItem::create('MODEL GENERATOR', Fa::Times_circle_o())
			->LinksTo('modelGenerator/modelGenerator.fwTools'),
		MenuItem::create('Form Generator', Fa::Times_circle_o())
			->LinksTo('formGenerator/formGenerator.fwTools'),
		MenuItem::create('Data seeder', Fa::Times_circle_o())
			->LinksTo('DataSeeder/DataSeeder.fwTools'),
	]);
}

$SideBar->render();
