<?php
/** @var FactorsEntity $factor */

use model\Teachers;
use model\Entity\StatesEntity;
use model\Entity\CitiesEntity;
use model\Entity\FactorsEntity;
use model\Entity\TeachersEntity;
use model\Entity\CustomersEntity;

/** @var CustomersEntity $customer */
$customer = \model\Customers::get($factor->customer_id);
/** @var StatesEntity $state */
$state = \model\States::get($customer->state_id);
/** @var CitiesEntity $city */
$city = \model\Cities::get($customer->city_id);
$data = json_decode($factor->data);
$teachers = json_decode($factor->teacher_ids,true);
if (!is_array($teachers)){
    $teachers = [];
}
?>
<!DOCTYPE html>
<html>
<head>
    <meta charset="utf-8"/>
    <meta name="viewport" content="width=device-width, initial-scale=1"/>
    <link rel="stylesheet" href="https://<?= __HOST__ ?>/src/dist/css/adminlte.min.css">
    <link rel="stylesheet" href="https://<?= __HOST__ ?>/src/dist/css/custom-style.css">

    <title>فاکتور فروش</title>
</head>
<body dir="rtl">
<div class="container-xl" style="margin-top: 100px;">
    <div class="row">
        <div class="col-3 text-center"></div>
        <div class="col-6 text-center"><h3 class="font-weight-bold">صورتحساب دوره</h3></div>
        <div class="col-3 text-right">
            <p>شماره سفارش: <?= en_to_fa(jdate("Y")) . $factor->factor_id ?></p>
            <p>تاریخ سفارش: <?= en_to_fa(jdate('Y/m/d', $factor->submit_date)) ?></p>
        </div>
    </div>
    <div class="row">
        <table class="table table-bordered">

            <thead>
            <tr>
                <th class="text-center" colspan="11">مشخصات خریدار</th>
            </tr>
            </thead>
            <tbody>
            <tr>
                <td colspan="11" class="text-center">
                    <div class="row">
                        <div class="col-4">
                            <p>نام: <?= $customer->first_name . ' ' . $customer->last_name ?></p>
                            <p>جنسیت: <?= $customer->gender == 1 ? "آقا" : "خانم" ?></p>
                        </div>
                        <div class="col-4">
                            <p>شماره همراه: <?= $customer->mobile ?></p>
                            <p>شهر و استان: <?= $state->name . ' - ' . $city->name ?></p>
                        </div>
                        <div class="col-4">
                            <p>شرکت: <?= $customer->company ?></p>
                            <p>سمت: <?= $customer->title ?></p>
                        </div>
                    </div>
                </td>
            </tr>
            </tbody>
            <thead>
            <tr>
                <th class="text-center" colspan="11">مشخصات دوره ها</th>
            </tr>
            </thead>
            <thead>
            <tr class="text-center">
                <th>ردیف</th>
                <th>کد دوره</th>
                <th>نام دوره</th>
                <th>تعداد</th>
                <th>مبلغ واحد (ریال)</th>
                <th>مبلغ کل (ریال)</th>
            </tr>
            </thead>
            <tbody>
			<?
			$i = 0;
			$total = 0;
			foreach ($data->data as $key => $row) {
				$total += $row->price * $row->count;
				$i++;
				?>
                <tr class="text-center">
                    <td><?= en_to_fa($i) ?></td>
                    <td><?= en_to_fa($key) ?></td>
                    <td><?= $row->courseName ?></td>
                    <td><?= en_to_fa($row->count) ?></td>
                    <td><?= en_to_fa(price_format($row->price)) ?></td>
                    <td><?= en_to_fa(price_format($row->price * $row->count)) ?></td>
                </tr>
				<?
			}
			?>
            <tr>
                <th colspan="5" class="text-center">جمع کل:</th>
                <th class="text-center"><?= price_format($total) ?></th>
            </tr>
            <tr>
                <th colspan="5" class="text-center">تخفیف:</th>
                <th class="text-center"><?= price_format($data->discountPrice) ?></th>
            </tr>
            <tr>
                <th colspan="5" class="text-center">مالیات بر ارزش افزوده:</th>
                <th class="text-center"><?= '%' . en_to_fa($data->tax) ?></th>
            </tr>
            <tr>
                <th colspan="5" class="text-center">مبلغ قابل پرداخت:</th>
                <th class="text-center"><?= price_format($total + $data->tax - ((int)$data->discountPrice)) ?></th>
            </tr>
            </tbody>
        </table>
    </div>
    <div class="text-center pr-5 pl-5">
        <h5>مدرسین:</h5>
        <div class="row d-flex flex-wrap pr-5 pl-5 text-center mr-2 ml-2">
			<?
			/** @var TeachersEntity $teacher */
			foreach ($teachers as $teacher) {
				$teacher = Teachers::get($teacher);
				$history = json_decode($teacher->history, true);
				$skill = json_decode($teacher->skills, true);
				$history = is_array($history) ? $history : [];
				$skill = is_array($skill) ? $skill : [];
				?>
                <div class="col-12 row card">
                    <div class="card-body row">
                        <img style="height: 75px;width: 75px" class="rounded-circle" alt="<?= $teacher->teacher_id ?>"
                             src="<?= __IMAGES__ . 'Teachers/' . $teacher->image ?>">
                        <div class="col text-right">
                            <h6><?= $teacher->name ?></h6>
                            <p class="text-dark">
								<?= $teacher->text ?>
                            </p>
                        </div>
                        <div class="col text-right">
                            <ul>
								<?
								foreach ($history as $item) {
									?>
                                    <li><?= $item ?></li>
									<?
								}
								?>
                            </ul>
                        </div>
                        <div class="col text-right">
                            <ul>
								<?
								foreach ($skill as $item) {
									?>
                                    <li><?= $item['skill'] . ' ' . (is_string($item['level']) ? $item['level'] : $item['level'][0]) ?></li>
									<?
								}
								?>
                            </ul>
                        </div>
                    </div>
                </div>
				<?
			}
			?>
        </div>
    </div>
</div>
</body>
</html>
