<?php

namespace FwMigrationSystem\User;

use FwMigrationSystem\Main\Migratable;
use FwMigrationSystem\Main\Migration;
use FwMigrationSystem\Resources\Blueprint;
use FwMigrationSystem\Resources\TableName;

class SecondCategoriesMigration extends Migratable {
    const modelName = 'SecondCategories';

    public function create_table() {
        return Migration::Create(new TableName(self::modelName), function (Blueprint $blueprint) {
            $blueprint->primary_key('second_categorie_id');
			$blueprint->VarChar('second_category_name')->Len(150);
			$blueprint->VarChar('second_category_short_name')->Len(150);
			$blueprint->Int('file_id')->Len(150);
			$blueprint->Text('created_at');

             return $blueprint;
        });
    }

    public function drop_table() {
        return Migration::DropIfExists(new TableName(self::modelName));
    }
}
