<?php

namespace FwMigrationSystem\User;

use FwMigrationSystem\Main\Migratable;
use FwMigrationSystem\Main\Migration;
use FwMigrationSystem\Resources\Blueprint;
use FwMigrationSystem\Resources\TableName;

class CancelRuleDetailsMigration extends Migratable {
    const modelName = 'CancelRuleDetails';

    public function create_table() {
        return Migration::Create(new TableName(self::modelName), function (Blueprint $blueprint) {
            $blueprint->primary_key('cancel_rule_detail_id');
			$blueprint->VarChar('cancel_rule_detail_more_than_number')->Len(150);
			$blueprint->Text('cancel_rule_detail_more_than_description');
			$blueprint->VarChar('cancel_rule_detail_less_than_number')->Len(150);
			$blueprint->Text('cancel_rule_detail_less_than_description');
			$blueprint->Text('cancel_rule_detail_after_reserve');
			$blueprint->Datetime('created_at')->Default('CURRENT_TIMESTAMP()');

             return $blueprint;
        });
    }

    public function drop_table() {
        return Migration::DropIfExists(new TableName(self::modelName));
    }
}
