<?php

namespace FwMigrationSystem\User;

use FwMigrationSystem\Main\Migratable;
use FwMigrationSystem\Main\Migration;
use FwMigrationSystem\Resources\Blueprint;
use FwMigrationSystem\Resources\TableName;

class AudioBookEpisodesMigration extends Migratable {
    const modelName = 'AudioBookEpisodes';

    public function create_table() {
        return Migration::Create(new TableName(self::modelName), function (Blueprint $blueprint) {
            $blueprint->primary_key('audio_book_episode_id');
			$blueprint->Int('audio_book_id')->Len(150);
			$blueprint->VarChar('episode_number')->Len(150);
			$blueprint->Text('episode_content');
			$blueprint->VarChar('episode_date')->Len(150);
			$blueprint->Datetime('created_at')->Default('CURRENT_TIMESTAMP()');

             return $blueprint;
        });
    }

    public function drop_table() {
        return Migration::DropIfExists(new TableName(self::modelName));
    }
}
