<?php

namespace model;

use DATABASE\Model;
use model\Entity\FilesEntity;
use model\Entity\UsersEntity;

class Notifications extends Model {
	public $_table = 'tblNotifications';
	public $_key = 'notification_id';
	public $_Entity = \model\Entity\NotificationsEntity::class;

	public static function send(string $title, string $text, UsersEntity $user, $file = null, string $route = '/profile') {
		sendPushNotification($user->firebase_token, $title, ['route' => $route], $text, $file instanceof FilesEntity ? $file->path() : "",);
		return Notifications::add([
			'notification_title' => $title,
			'notification_text'  => $text,
			'user_id'            => $user->user_id,
			'notification_image' => $file instanceof FilesEntity ? $file->file_id : 0,
			'notification_url'   => $route,
		]);
	}

}