<?

namespace view;

use DOMWrap\Document;
use FwHtml\Elements\Tags\Main\HtmlTags;
use FwHtml\Elements\Tags\Table;
use FwHtml\FontAwesome;
use View;

class Artists extends View
{

    public $SingularName = 'هنرمند';

    public function main(Document &$document)
    {
        $document->html = $this->Html()->BreadCrumbs() . HtmlTags::Section('.content')
                ->Content(
                    HtmlTags::Div('.row')
                        ->Content(
                            HtmlTags::Div('.col-md-12')->Content(
                                HtmlTags::Div('.card.card-primary.card-outline')
                                    ->Content(
                                        HtmlTags::Div('.card-header')
                                            ->Content(
                                                $this->Html()->CardTitle(),
                                                $this->Html()->refreshAndAdd()
                                            ),
                                        HtmlTags::Div('.card-body.d-flex.flex-wrap')
                                            ->Content(
                                                HtmlTags::Table('.table.table-bordered.table-striped')
                                                    ->Content(
                                                        HtmlTags::Thead('.table-dark')
                                                            ->Content(
                                                                HtmlTags::Tr()->Content(
                                                                    HtmlTags::Th('ردیف')->Width('50'),
                                                                    HtmlTags::Th('نام'),
                                                                    HtmlTags::Th('تصویر'),
                                                                    HtmlTags::Th('حرفه'),

                                                                    HtmlTags::Th('.no-sort عملیات')->Width('150')
                                                                )
                                                            ),
                                                        HtmlTags::Tbody()
                                                            ->Content(
                                                                $this->show([
                                                                    'artist_name',
                                                                    'showImage' => "artist_image",
                                                                    'artist_job'
                                                                ])
                                                            )
                                                    )
                                            )
                                    )
                            )
                        )
                );
    }

    public function Form()
    {
        return $this->Html()->BreadCrumbs() . HtmlTags::Section('.content')
                ->Content(
                    HtmlTags::Div('.row')
                        ->Content(
                            HtmlTags::Div('.col-md-12')->Content(
                                HtmlTags::Div('.card.card-primary.card-outline')
                                    ->Content(
                                        HtmlTags::Div('.card-header')
                                            ->Content(
                                                $this->Html()->CardTitle(),
                                                $this->Html()->refreshAndBack()
                                            ),
                                        $this->Html()->FormStart() .

                                        $this->Html()->FormGroupStart(4) .
                                        $this->Html()->Label('نام کامل') .
                                        $this->Html()->Input('artist_name') .
                                        $this->Html()->FormGroupEnd() .

                                        $this->Html()->FormGroupStart(4) .
                                        $this->Html()->Label('تصویر') .
                                        $this->Html()->ImageInput('artist_image') .
                                        $this->Html()->FormGroupEnd() .

                                        $this->Html()->FormGroupStart(4) .
                                        $this->Html()->Label('حرفه') .
                                        $this->Html()->Input('artist_job') .
                                        $this->Html()->FormGroupEnd() .

                                        $this->Html()->FormGroupStart(12) .
                                        $this->Html()->Label('بیوگرافی') .
                                        $this->Html()->TextArea('artist_bio') .
                                        $this->Html()->FormGroupEnd() .

                                        $this->Html()->FormGroupStart(4) .
                                        $this->Html()->Label('درصد تسویه') .
                                        $this->Html()->Price('artist_share', 'artist_share', '%') .
                                        $this->Html()->FormGroupEnd() .

                                        $this->Html()->FormGroupStart(4) .
                                        $this->Html()->Label('در قید حیات') .
                                        $this->Html()->Select('artist_alive', 'artist_alive', HtmlTags::Option()->Value(1)->Content("بله") . HtmlTags::Option()->Value(0)->Content("خیر")) .
                                        $this->Html()->FormGroupEnd() .

                                        $this->Html()->FormGroupStart(4) .
                                        $this->Html()->Label('حوزه فعالیت') .
                                        $this->Html()->Select('artist_activity[]', 'artist_activity', HtmlTags::Option()->Selected()->Disabled()->Content('لطفا یک مورد را انتخاب کنید') . HtmlTags::Option()->Value("Book")->Content("کتاب") . HtmlTags::Option()->Value("Story")->Content("داستان") . HtmlTags::Option()->Value("AudioBook")->Content("کتاب صوتی"), true) .
                                        $this->Html()->FormGroupEnd() .

                                        $this->Html()->FormGroupStart(12, 'mt-2', 'showFields') .
                                        HtmlTags::Label('.w-100')->Content(
                                            "راه های ارتباطی",
                                            HtmlTags::Button('.btn.mr-2.btn-success.p-2#addField')->Content(
                                                HtmlTags::I('.ml-1')->Class(FontAwesome::Plus()),
                                                "افزودن",
                                            )->Type('button'),
                                        ),
                                        $this->buildTable() .
                                        $this->Html()->FormGroupEnd() .

                                        $this->Html()->CardFooter()
                                    )
                            )
                        )
                );
    }

    private function buildTable(): Table {
        return HtmlTags::Table('.table.table-bordered.table-striped')->Content(
            HtmlTags::Thead()->Content(
                HtmlTags::Th()->Content("#"),
                HtmlTags::Th("مقدار"),
                HtmlTags::Th("عملیات"),
            ),
            HtmlTags::Tbody("#fieldsBody")->Content(
                function () {
                    $data = $this->getData();
                    if (isset($data)) {
                        $fields = json_decode($this->getData()->artist_social_media . '', true);
                        $output = [];
                        if (is_array($fields)) {
                            foreach ($fields as $field) {
                                $output[] = HtmlTags::Tr()->Content(
                                    HtmlTags::Td()->Content(
                                        HtmlTags::Td()->Content(
                                            HtmlTags::Input('.form-control')->Type('text')->Name('artist_social_media[]')->Value($field)
                                        ),
                                        HtmlTags::Td()->Content(
                                            HtmlTags::Button('.btn.btn-danger.p-2.deleteField')->Type('button')->Content(
                                                HtmlTags::I('.fa.fa-trash')
                                            )
                                        )
                                    )
                                );
                            }
                        }
                        return implode('', $output);
                    }
                    return "";
                }

            ),
        );
    }



    public function addIndex(Document &$document)
    {
        $document->html = $this->Form();
    }

    public function editIndex(Document &$document)
    {
        $this->doFill();
        $document->html = $this->Form();
    }

    public function deleteIndex(Document &$document)
    {
        $this->doFill();
        $this->doDisableAll();
        $document->html = $this->Form();
    }

    public function viewIndex(Document &$document)
    {
        $this->doFill();
        $this->doDisableAll();
        $document->html = $this->Form();
    }

}
        