<?

namespace view;

use DOMWrap\Document;
use FwHtml\Elements\Tags\Main\HtmlTags;
use View;

class Books extends View
{

    public $SingularName = 'کتاب';

    public function main(Document &$document)
    {
        $document->html = $this->Html()->BreadCrumbs() . HtmlTags::Section('.content')
                ->Content(
                    HtmlTags::Div('.row')
                        ->Content(
                            HtmlTags::Div('.col-md-12')->Content(
                                HtmlTags::Div('.card.card-primary.card-outline')
                                    ->Content(
                                        HtmlTags::Div('.card-header')
                                            ->Content(
                                                $this->Html()->CardTitle(),
                                                $this->Html()->refreshAndAdd()
                                            ),
                                        HtmlTags::Div('.card-body.d-flex.flex-wrap')
                                            ->Content(
                                                HtmlTags::Table('.table.table-bordered.table-striped')
                                                    ->Content(
                                                        HtmlTags::Thead('.table-dark')
                                                            ->Content(
                                                                HtmlTags::Tr()->Content(
                                                                    HtmlTags::Th('ردیف')->Width('50'),
                                                                    HtmlTags::Th('نام'), HtmlTags::Th('قیمت'), HtmlTags::Th('خلاصه داستان'),
                                                                    HtmlTags::Th('.no-sort عملیات')->Width('150')
                                                                )
                                                            ),
                                                        HtmlTags::Tbody()
                                                            ->Content(
                                                                $this->show(['book_name',
                                                                             'price_format'=>'book_price',
                                                                             'book_summary'])
                                                            )
                                                    )
                                            )
                                    )
                            )
                        )
                );
    }

    public function Form()
    {
        return $this->Html()->BreadCrumbs() . HtmlTags::Section('.content')
                ->Content(
                    HtmlTags::Div('.row')
                        ->Content(
                            HtmlTags::Div('.col-md-12')->Content(
                                HtmlTags::Div('.card.card-primary.card-outline')
                                    ->Content(
                                        HtmlTags::Div('.card-header')
                                            ->Content(
                                                $this->Html()->CardTitle(),
                                                $this->Html()->refreshAndBack()
                                            ),
                                        $this->Html()->FormStart() .

                                        $this->Html()->FormGroupStart(6) .
                                        $this->Html()->Label('نام') .
                                        $this->Html()->Input('book_name') .
                                        $this->Html()->FormGroupEnd() .

                                        $this->Html()->FormGroupStart(6) .
                                        $this->Html()->Label('نویسنده') .
                                        $this->Html()->Select('artist_id','artist_id',\model\Artists::toOption()) .
                                        $this->Html()->FormGroupEnd() .

                                        $this->Html()->FormGroupStart(6) .
                                        $this->Html()->Label('کاور') .
                                        $this->Html()->ImageInput('book_cover', 'image/jpeg', 150, 150) .
                                        $this->Html()->FormGroupEnd() .

                                        $this->Html()->FormGroupStart(6) .
                                        $this->Html()->Label('قیمت') .
                                        $this->Html()->Price('book_price') .
                                        $this->Html()->FormGroupEnd() .

                                        $this->Html()->FormGroupStart(12) .
                                        $this->Html()->Label('خلاصه داستان') .
                                        $this->Html()->TextArea('book_summary') .
                                        $this->Html()->FormGroupEnd() .

                                        $this->Html()->FormGroupStart(4) .
                                        $this->Html()->Label('انتخاب برچسب ها') .
                                        $this->Html()->Select('label_ids[]', 'label_ids', \model\Labels::toOption(),true) .
                                        $this->Html()->FormGroupEnd() .

                                        $this->Html()->FormGroupStart(2) .
                                        $this->Html()->Label('تعداد صفحات') .
                                        $this->Html()->Number('book_pages_number', 'book_pages_number') .
                                        $this->Html()->FormGroupEnd() .
                                        $this->Html()->FormGroupStart(2) .
                                        $this->Html()->Label('تاریخ انتشار') .
                                        $this->Html()->Date('book_publish_date') .
                                        $this->Html()->FormGroupEnd() .

                                        $this->Html()->FormGroupStart(4) .
                                        $this->Html()->Label('کتاب') .
                                        $this->FilePicker('file_id') .
                                        $this->Html()->FormGroupEnd() .

                                        $this->Html()->CardFooter()
                                    )
                            )
                        )
                );
    }

    public function addIndex(Document &$document)
    {
        $document->html = $this->Form();
    }

    public function editIndex(Document &$document)
    {
        $this->doFill();
        $document->html = $this->Form();
    }

    public function deleteIndex(Document &$document)
    {
        $this->doFill();
        $this->doDisableAll();
        $document->html = $this->Form();
    }

    public function viewIndex(Document &$document)
    {
        $this->doFill();
        $this->doDisableAll();
        $document->html = $this->Form();
    }

}
        