<?

namespace view;

use DOMWrap\Document;
use FwHtml\Elements\Tags\Main\HtmlTags;
use FwHtml\FontAwesome;
use model\Entity\UsersEntity;
use View;

class Events extends View {

	public $SingularName = 'رویداد';

	public function main(Document &$document) {
		$document->html = $this->Html()->BreadCrumbs() . HtmlTags::Section('.content')
				->Content(
					HtmlTags::Div('.row')
						->Content(
							HtmlTags::Div('.col-md-12')->Content(
								HtmlTags::Div('.card.card-primary.card-outline')
									->Content(
										HtmlTags::Div('.card-header')
											->Content(
												$this->Html()->CardTitle(),
												$this->Html()->refreshAndAdd()
											),
										HtmlTags::Div('.card-body.d-flex.flex-wrap')
											->Content(
												HtmlTags::Table('.table.table-bordered.table-striped')
													->Content(
														HtmlTags::Thead('.table-dark')
															->Content(
																HtmlTags::Tr()->Content(
																	HtmlTags::Th('ردیف')->Width('50'),
																	HtmlTags::Th('نام'),
																	HtmlTags::Th('تصویر'),
																	HtmlTags::Th('لوکیشن'),

																	HtmlTags::Th('.no-sort عملیات')->Width('150')
																)
															),
														HtmlTags::Tbody()
															->Content(
																$this->show([
																	'event_name',
																	'showImage' => "event_cover",
																	'event_location'
																])
															)
													)
											)
									)
							)
						)
				);
	}

	public function addIndex(Document &$document) {
		$document->html = $this->Form();
	}

	public function Form() {
		return $this->Html()->BreadCrumbs() . HtmlTags::Section('.content')
				->Content(
					HtmlTags::Div('.row')
						->Content(
							HtmlTags::Div('.col-md-12')->Content(
								HtmlTags::Div('.card.card-primary.card-outline')
									->Content(
										HtmlTags::Div('.card-header')
											->Content(
												$this->Html()->CardTitle(),
												$this->Html()->refreshAndBack()
											),
										$this->Html()->FormStart() .

										$this->Html()->FormGroupStart(4) .
										$this->Html()->Label('نام رویداد') .
										$this->Html()->Input('event_name') .
										$this->Html()->FormGroupEnd() .

										$this->Html()->FormGroupStart(4) .
										$this->Html()->Label('تصویر') .
										$this->Html()->ImageInput('event_cover') .
										$this->Html()->FormGroupEnd() .

										$this->Html()->FormGroupStart(4) .
										$this->Html()->Label('لوکیشن') .
										$this->Html()->Input('event_location') .
										$this->Html()->FormGroupEnd() .

										$this->Html()->FormGroupStart(4) .
										$this->Html()->Label('تاریخ') .
										$this->Html()->Date('event_datetime') .
										$this->Html()->FormGroupEnd() .


										$this->Html()->FormGroupStart(4) .
										$this->Html()->Label('ظرفیت') .
										$this->Html()->Price('event_capacity', 'event_capacity', 'نفر') .
										$this->Html()->FormGroupEnd() .

										$this->Html()->FormGroupStart(4) .
										$this->Html()->Label('ورودی') .
										$this->Html()->Price('event_entry_price', 'event_entry_price') .
										$this->Html()->FormGroupEnd() .

										$this->Html()->FormGroupStart(12) .
										$this->Html()->Label('یادداشت ها') .
										$this->Html()->TextArea('event_notes') .
										$this->Html()->FormGroupEnd() .

										$this->Html()->FormGroupStart(12) .
										$this->Html()->Label('متن') .
										$this->Html()->TextArea('event_text') .
										$this->Html()->FormGroupEnd() .


										$this->Html()->CardFooter()
									)
							)
						)
				);
	}

	public function editIndex(Document &$document) {
		$this->doFill();
		$document->html = $this->Form();
	}

	public function deleteIndex(Document &$document) {
		$this->doFill();
		$this->doDisableAll();
		$document->html = $this->Form();
	}

	public function viewIndex(Document &$document) {
		$this->doFill();
		$this->doDisableAll();
		$document->html = $this->Form();
	}

	public function cardPayments(Document &$document) {
		$this->PluralName = "کارت به کارت";
		$document->html = $this->Html()->BreadCrumbs() . HtmlTags::Section('.content')
				->Content(
					HtmlTags::Div('.row')
						->Content(
							HtmlTags::Div('.col-md-12')->Content(
								HtmlTags::Div('.card.card-primary.card-outline')
									->Content(
										HtmlTags::Div('.card-header')
											->Content(
												$this->Html()->CardTitle(),
												$this->Html()->refresh()
											),
										HtmlTags::Div('.card-body.d-flex.flex-wrap')
											->Content(
												HtmlTags::Table('.table.table-bordered.table-striped')
													->Content(
														HtmlTags::Thead('.table-dark')
															->Content(
																HtmlTags::Tr()->Content(
																	HtmlTags::Th('ردیف')->Width('50'),
//                                                                    HtmlTags::Th('نام کامل'),
																	HtmlTags::Th('شماره همراه یا ایمیل'),
																	HtmlTags::Th('مبلغ پرداخت شده'),
																	HtmlTags::Th('رویداد و ظرفیت'),
																	HtmlTags::Th('تاریخ و ساعت'),
																	HtmlTags::Th('فیش واریزی'),
//                                                                    HtmlTags::Th('کیف پول'),
																	HtmlTags::Th('.no-sort عملیات')->Width('150'),
																)
															),
														HtmlTags::Tbody()
															->Content(
																$this->show([
																	'user_id'        => function ($userId) {
																		$user = \model\Users::get($userId);
																		if ($user instanceof UsersEntity) {

																			return $user->mobile;
																		}
																		return "$userId";
																	},
																	'payment_amount' => function ($amount) {
																		return price_format($amount / 10);
																	},
																	function ($data) {
																		$datum = json_decode($data->payment_data);
																		$event = \model\Events::get($datum->eventId);
																		return $event->name.' '.price_format($event->entry_price) . " - تعداد: " . $datum->count;
																	},
																	'payment_date'   => function ($date) {
																		return jdate("Y/m/d H:i", $date);
																	},
																	'payment_data'   => function ($data) {
																		$data = json_decode($data);
																		if ($data) {
																			return HtmlTags::Img('.previewMe')->Src(__IMAGES__ . 'Payment/' . $data->receipt)->Attrs(['style' => 'height: 10rem']);
																		}
																		return "no receipt";
																	},
																], false, false, false, false, function ($row) {
																	if ($row->payment_status == 1) {
																		return "";
																	} else {
																		return HtmlTags::A('.btn.btn-success.p-2.confirmPayment')->Content(
																			HtmlTags::I(".m-0.p-1")->Class(FontAwesome::Check())
																		)->Data_('status', '1')
																			->Data_('id', $row->payment_id)
																			->Data_('toggle', 'tooltip')
																			->Data_('placement', 'top')
																			->Title('تایید پرداخت');
																	}
																}, function ($row) {
																	if ($row->payment_status == 1) {
																		return "";
																	} else {
																		return HtmlTags::A('.btn.btn-danger.mr-1.p-2.deletePayment')->Content(
																			HtmlTags::I(".m-0.p-1")->Class(FontAwesome::Trash())
																		)
																			->Data_('id', $row->payment_id)
																			->Data_('toggle', 'tooltip')
																			->Data_('placement', 'top')
																			->Title('حذف؟ مطمئن هستید؟');
																	}
																})
															)
													)
											)
									)
							)
						)
				);
	}

	public function cryptoPayments(Document &$document) {
		$this->PluralName = "ارز دیجیتال";
		$document->html = $this->Html()->BreadCrumbs() . HtmlTags::Section('.content')
				->Content(
					HtmlTags::Div('.row')
						->Content(
							HtmlTags::Div('.col-md-12')->Content(
								HtmlTags::Div('.card.card-primary.card-outline')
									->Content(
										HtmlTags::Div('.card-header')
											->Content(
												$this->Html()->CardTitle(),
												$this->Html()->refresh()
											),
										HtmlTags::Div('.card-body.d-flex.flex-wrap')
											->Content(
												HtmlTags::Table('.table.table-bordered.table-striped')
													->Content(
														HtmlTags::Thead('.table-dark')
															->Content(
																HtmlTags::Tr()->Content(
																	HtmlTags::Th('ردیف')->Width('50'),
//                                                                    HtmlTags::Th('نام کامل'),
																	HtmlTags::Th('شماره همراه یا ایمیل'),
																	HtmlTags::Th('مبلغ پرداخت شده'),
																	HtmlTags::Th('رویداد و تعداد'),
																	HtmlTags::Th('تاریخ و ساعت'),
																	HtmlTags::Th('فیش واریزی'),
//                                                                    HtmlTags::Th('کیف پول'),
																	HtmlTags::Th('.no-sort عملیات')->Width('150'),
																)
															),
														HtmlTags::Tbody()
															->Content(
																$this->show([
																	'user_id'        => function ($userId) {
																		$user = \model\Users::get($userId);
																		if ($user instanceof UsersEntity) {

																			return $user->mobile;
																		}
																		return "$userId";
																	},
																	'payment_amount' => function ($amount) {
																		return price_format($amount / 10);
																	},
																	function ($data) {
																		$datum = json_decode($data->payment_data);
																		$event = \model\Events::get($datum->eventId);
																		return $event->name.' '.price_format($event->entry_price) . " - تعداد: " . $datum->count;
																	},
																	'payment_date'   => function ($date) {
																		return jdate("Y/m/d H:i", $date);
																	},
																	'payment_data'   => function ($data) {
																		$data = json_decode($data);
																		if ($data) {
																			return HtmlTags::Img('.previewMe')->Src(__IMAGES__ . 'Payment/' . $data->receipt)->Attrs(['style' => 'height: 10rem']);
																		}
																		return "no receipt";
																	},
																], false, false, false, false, function ($row) {
																	if ($row->payment_status == 1) {
																		return "";
																	} else {
																		return HtmlTags::A('.btn.btn-success.p-2.confirmPayment')->Content(
																			HtmlTags::I(".m-0.p-1")->Class(FontAwesome::Check())
																		)->Data_('status', '1')
																			->Data_('id', $row->payment_id)
																			->Data_('toggle', 'tooltip')
																			->Data_('placement', 'top')
																			->Title('تایید پرداخت');
																	}
																}, function ($row) {
																	if ($row->payment_status == 1) {
																		return "";
																	} else {
																		return HtmlTags::A('.btn.btn-danger.mr-1.p-2.deletePayment')->Content(
																			HtmlTags::I(".m-0.p-1")->Class(FontAwesome::Trash())
																		)
																			->Data_('id', $row->payment_id)
																			->Data_('toggle', 'tooltip')
																			->Data_('placement', 'top')
																			->Title('حذف؟ مطمئن هستید؟');
																	}
																})
															)
													)
											)
									)
							)
						)
				);
	}

}
        