<?
namespace view;
use DOMWrap\Document;
use FwHtml\Elements\Tags\Main\HtmlTags;
use View;
class Rewards extends View
{

    public $SingularName = 'جایزه';

    public function main(Document &$document)
    {
        $document->html = $this->Html()->BreadCrumbs() . HtmlTags::Section('.content')
                ->Content(
                    HtmlTags::Div('.row')
                        ->Content(
                            HtmlTags::Div('.col-md-12')->Content(
                                HtmlTags::Div('.card.card-primary.card-outline')
                                    ->Content(
                                        HtmlTags::Div('.card-header')
                                            ->Content(
                                                $this->Html()->CardTitle(),
                                                $this->Html()->refreshAndAdd()
                                            ),
                                        HtmlTags::Div('.card-body.d-flex.flex-wrap')
                                            ->Content(
                                                HtmlTags::Table('.table.table-bordered.table-striped')
                                                    ->Content(
                                                        HtmlTags::Thead('.table-dark')
                                                            ->Content(
                                                                HtmlTags::Tr()->Content(
                                                                    HtmlTags::Th('ردیف')->Width('50'),
                                                                    HtmlTags::Th('عنوان جایزه'),HtmlTags::Th('امتیاز مورد نیاز'),HtmlTags::Th('توضیحات'),
                                                                    HtmlTags::Th('.no-sort عملیات')->Width('150')
                                                                )
                                                            ),
                                                        HtmlTags::Tbody()
                                                            ->Content(
                                                                $this->show(['reward_name','reward_required_points','reward_text'])
                                                            )
                                                    )
                                            )
                                    )
                            )
                        )
                );
    }
    
    public function Form()
    {
        return $this->Html()->BreadCrumbs() .HtmlTags::Section('.content')
    ->Content(
        HtmlTags::Div('.row')
            ->Content(
                HtmlTags::Div('.col-md-12')->Content(
                    HtmlTags::Div('.card.card-primary.card-outline')
                        ->Content(
                            HtmlTags::Div('.card-header')
                                ->Content(
                                    $this->Html()->CardTitle(),
                                    $this->Html()->refreshAndBack()
                                ),
                                    $this->Html()->FormStart().
                                      $this->Html()->FormGroupStart(3) .
                            $this->Html()->Label('عنوان جایزه') .
                            $this->Html()->Input('reward_name') .
                            $this->Html()->FormGroupEnd() .
                            
                            $this->Html()->FormGroupStart(3) .
                            $this->Html()->Label('دسته بندی ') .
                            $this->Html()->Select('reward_category_id', 'reward_category_id',  \model\RewardCategories::toOption()) .
                            $this->Html()->FormGroupEnd() .
                            
                            $this->Html()->FormGroupStart(3) .
                            $this->Html()->Label('امتیاز مورد نیاز') .
                            $this->Html()->Number('reward_required_points','reward_required_points') .
                            $this->Html()->FormGroupEnd() .
                            
                            $this->Html()->FormGroupStart(3) .
                            $this->Html()->Label('تصویر') .
                            $this->Html()->ImageInput('reward_cover','image/jpeg',960,240).
                            $this->Html()->FormGroupEnd() .
                            
                            $this->Html()->FormGroupStart(12) .
                            $this->Html()->Label('توضیحات') .
                            $this->Html()->Input('reward_text') .
                            $this->Html()->FormGroupEnd()  .
                                    $this->Html()->CardFooter()
                        )
                )
            )
    );
    }
    
    public function addIndex(Document &$document)
    {
        $document->html = $this->Form();
    }
    
    public function editIndex(Document &$document)
    {
        $this->doFill();
        $document->html = $this->Form();
    }
    
    public function deleteIndex(Document &$document)
    {
        $this->doFill();
        $this->doDisableAll();
        $document->html = $this->Form();
    }
    
    public function viewIndex(Document &$document)
    {
        $this->doFill();
        $this->doDisableAll();
        $document->html = $this->Form();
    }

}
        