<?

namespace view;

use DOMWrap\Document;
use FwHtml\Elements\Tags\Main\HtmlTags;
use View;

class Poets extends View {

	public $SingularName = 'شاعر';

	public function main(Document &$document) {
		$document->html = $this->Html()->BreadCrumbs() . HtmlTags::Section('.content')
				->Content(
					HtmlTags::Div('.row')
						->Content(
							HtmlTags::Div('.col-md-12')->Content(
								HtmlTags::Div('.card.card-primary.card-outline')
									->Content(
										HtmlTags::Div('.card-header')
											->Content(
												$this->Html()->CardTitle(),
												$this->Html()->refreshAndAdd()
											),
										HtmlTags::Div('.card-body.d-flex.flex-wrap')
											->Content(
												HtmlTags::Table('.table.table-bordered.table-striped')
													->Content(
														HtmlTags::Thead('.table-dark')
															->Content(
																HtmlTags::Tr()->Content(
																	HtmlTags::Th('ردیف')->Width('50'),
																	HtmlTags::Th('نام شاعر'),
																	HtmlTags::Th('.no-sort عملیات')->Width('150')
																)
															),
														HtmlTags::Tbody()
															->Content(
																$this->show(['poet_name',])
															)
													)
											)
									)
							)
						)
				);
	}

	public function addIndex(Document &$document) {
		$document->html = $this->Form();
	}

	public function Form() {
		return $this->Html()->BreadCrumbs() . HtmlTags::Section('.content')
				->Content(
					HtmlTags::Div('.row')
						->Content(
							HtmlTags::Div('.col-md-12')->Content(
								HtmlTags::Div('.card.card-primary.card-outline')
									->Content(
										HtmlTags::Div('.card-header')
											->Content(
												$this->Html()->CardTitle(),
												$this->Html()->refreshAndBack()
											),
										$this->Html()->FormStart() .
										$this->Html()->FormGroupStart(4) .
										$this->Html()->Label('نام شاعر') .
										$this->Html()->Input('poet_name') .
										$this->Html()->FormGroupEnd() .

										$this->Html()->FormGroupStart(4) .
										$this->Html()->Label('قرن ') .
										$this->Html()->Select('time_period_id', 'time_period_id', \model\TimePeriods::toOption()) .
										$this->Html()->FormGroupEnd() .

										$this->Html()->FormGroupStart(4) .
										$this->Html()->Label('سبک شعری') .
										$this->Html()->Select('poetic_style_id[]', 'poetic_style_id', \model\PoeticStyles::toOption(), true) .
										$this->Html()->FormGroupEnd() .

										$this->Html()->FormGroupStart(4) .
										$this->Html()->Label('موضوع اشعار') .
										$this->Html()->Select('poem_theme_id[]', 'poem_theme_id', \model\PoemThemes::toOption(), true) .
										$this->Html()->FormGroupEnd() .

										$this->Html()->FormGroupStart(4) .
										$this->Html()->Label('منطقه جغرافیایی') .
										$this->Html()->Select('location_id', 'location_id', \model\Locations::toOption()) .
										$this->Html()->FormGroupEnd() .

										$this->Html()->FormGroupStart(4) .
										$this->Html()->Label('تصویر شاعر') .
										$this->Html()->ImageInput('poet_image') .
										$this->Html()->FormGroupEnd() .

										$this->Html()->FormGroupStart(12) .
										$this->Html()->Label('بیوگرافی') .
										$this->Html()->TextArea('poet_bio') .
										$this->Html()->FormGroupEnd() .
										$this->Html()->CardFooter()
									)
							)
						)
				);
	}

	public function editIndex(Document &$document) {
		$this->doFill();
		$document->html = $this->Form();
	}

	public function deleteIndex(Document &$document) {
		$this->doFill();
		$this->doDisableAll();
		$document->html = $this->Form();
	}

	public function viewIndex(Document &$document) {
		$this->doFill();
		$this->doDisableAll();
		$document->html = $this->Form();
	}

}
        