<?

namespace view;

use DOMWrap\Document;
use FwHtml\Elements\Tags\Main\HtmlTags;
use FwHtml\FontAwesome;
use View;

class Stories extends View {

	public $SingularName = 'داستان';

	public function main(Document &$document) {
		$document->html = $this->Html()->BreadCrumbs() . HtmlTags::Section('.content')
				->Content(
					HtmlTags::Div('.row')
						->Content(
							HtmlTags::Div('.col-md-12')->Content(
								HtmlTags::Div('.card.card-primary.card-outline')
									->Content(
										HtmlTags::Div('.card-header')
											->Content(
												$this->Html()->CardTitle(),
												$this->Html()->refreshAndAdd()
											),
										HtmlTags::Div('.card-body.d-flex.flex-wrap')
											->Content(
												HtmlTags::Table('.table.table-bordered.table-striped')
													->Content(
														HtmlTags::Thead('.table-dark')
															->Content(
																HtmlTags::Tr()->Content(
																	HtmlTags::Th('ردیف')->Width('50'),
																	HtmlTags::Th('نام داستان'),
																	HtmlTags::Th('تاریخ شروع داستان'),
																	HtmlTags::Th('وضعیت داستان'),
																	HtmlTags::Th('اشتراک مورد نیاز'),
																	HtmlTags::Th('.no-sort عملیات')->Width('150')
																)
															),
														HtmlTags::Tbody()
															->Content(
																$this->show([
																	'story_name',
																	'story_start_date',
																	'is_ended' => function ($item) {
																		switch ($item) {
																			case 1:
																				return 'پایان یافته';
																				break;
																			case 0:
																				return 'درحال پخش';
																				break;
																			default:
																				return "نامشخص";
																				break;
																		}
																	},
																	'plan_id'  => function ($planId) {
																		if ($planId != 0) {
																			return \model\Memberships::get($planId)->membership_name;
																		} else {
																			return "رایگان";
																		}
																	}
																], true, true, false, false, function ($row) {
																	if ($row->is_ended == '0') {
																		return HtmlTags::Button('.btn.btn-outline-dark.m-2.p-2.endStory')->Content(
																			HtmlTags::I(".m-0.p-1")->Class(FontAwesome::Hand_paper_o()),
																		)->Data_('toggle', 'tooltip')
																			->Data_('placement', 'top')
																			->Title('پایان داستان')->Data_('id', $row->story_id);
																	} else {
																		return HtmlTags::Button('.btn.btn-outline-success.m-2.p-2.continueStory')->Content(
																			HtmlTags::I(".m-0.p-1")->Class(FontAwesome::Road()),
																		)->Data_('toggle', 'tooltip')
																			->Data_('placement', 'top')
																			->Title('ادامه داستان')->Data_('id', $row->story_id);
																	}
																}, function ($row) {
																	return HtmlTags::Button('.btn.btn-outline-primary.m-2.p-2.episodes')->Content(
																		HtmlTags::I(".m-0.p-1")->Class(FontAwesome::List_ol()),
																	)->Data_('toggle', 'tooltip')
																		->Data_('placement', 'top')
																		->Data_('id', $row->story_id)->Data_('title', $row->name)
																		->Title('نمایش اپیزود ها');
																})
															)
													)
											)
									)
							)
						)
				) . $this->buildEpisodesModal();
	}

	//private function buildEpisodesModal() {
	//	return HtmlTags::Div(".modal.fade#episodesModal")->Content(
	//		HtmlTags::Div('.modal-dialog.modal-lg')->Content(
	//			HtmlTags::Div('.modal-content')->Content(
	//				HtmlTags::Div('.modal-header')->Content(
	//					HtmlTags::H4('.modal-title#episodesModalTitle')->Content(),
	//					HtmlTags::Div('.pull-left')->Content(
	//						HtmlTags::Button('.close')->Content('&times;')->Data_('dismiss', 'modal')->Type('button')
	//					)
	//				),
	//				HtmlTags::Form()->Content(
	//					HtmlTags::Div('.modal-body.d-flex.flex-wrap.justify-center')->Content()
	//				)
	//			)
	//		)
	//	);
	//}

    private function buildEpisodesModal() {
        return HtmlTags::Div(".modal.fade#episodesModal")->Content(
            HtmlTags::Div('.modal-dialog.modal-xl')->Content( // تغییر به modal-xl برای افزایش عرض
                HtmlTags::Div('.modal-content')->Content(
                    HtmlTags::Div('.modal-header')->Content(
                        HtmlTags::H4('.modal-title#episodesModalTitle')->Content(),
                        HtmlTags::Div('.pull-left')->Content(
                            HtmlTags::Button('.close')->Content('&times;')->Data_('dismiss', 'modal')->Type('button')
                        )
                    ),
                    HtmlTags::Form()->Content(
                        HtmlTags::Div('.modal-body.d-flex.flex-wrap.justify-center')->Content(
                            HtmlTags::Div('.table-responsive')->Content( // اضافه کردن table-responsive
                                HtmlTags::Table('.table.table-bordered.table-striped.w-100')->Content(  // اضافه کردن w-100 برای جدول
                                // محتوای جدول
                                )
                            )
                        )
                    )
                )
            )
        );
    }


    public function Form() {
		return $this->Html()->BreadCrumbs() . HtmlTags::Section('.content')
				->Content(
					HtmlTags::Div('.row')
						->Content(
							HtmlTags::Div('.col-md-12')->Content(
								HtmlTags::Div('.card.card-primary.card-outline')
									->Content(
										HtmlTags::Div('.card-header')
											->Content(
												$this->Html()->CardTitle(),
												$this->Html()->refreshAndBack()
											),
										$this->Html()->FormStart() .
										$this->Html()->FormGroupStart(4) .
										$this->Html()->Label('نام داستان') .
										$this->Html()->Input('story_name') .
										$this->Html()->FormGroupEnd() .

										$this->Html()->FormGroupStart(4) .
										$this->Html()->Label('کاور') .
										$this->Html()->ImageInput('story_cover', 'image/jpeg', 150, 150) .
										$this->Html()->FormGroupEnd() .

										$this->Html()->FormGroupStart(4) .
										$this->Html()->Label('برچسب ها') .
										$this->Html()->Select('label_ids[]', 'label_ids', \model\Labels::toOption(), true) .
										$this->Html()->FormGroupEnd() .

										$this->Html()->FormGroupStart(4) .
										$this->Html()->Label('وضعیت داستان') .
										$this->Html()->Select('is_ended', 'is_ended',
											HtmlTags::Option()->Selected()->Value('0')->Content('درحال پخش') .
											HtmlTags::Option()->Value('1')->Content('پایان یافته')
										) .
										$this->Html()->FormGroupEnd() .

										$this->Html()->FormGroupStart(4) .
										$this->Html()->Label('نوع داستان') .
										$this->Html()->Select('is_daily', 'is_daily',
											HtmlTags::Option()->Selected()->Value('0')->Content('معمولی') .
											HtmlTags::Option()->Value('1')->Content('روزانه')
										) .
										$this->Html()->FormGroupEnd() .

										$this->Html()->FormGroupStart(4) .
										$this->Html()->Label('انتخاب پلن') .
										$this->Html()->Select('plan_id', 'plan_id', \model\Memberships::toOption()) .
										$this->Html()->FormGroupEnd() .
										$this->Html()->CardFooter()
									)
							)
						)
				);
	}

	public function addIndex(Document &$document) {
		$document->html = $this->Form();
	}

	public function editIndex(Document &$document) {
		$this->doFill();
		$document->html = $this->Form();
	}

	public function deleteIndex(Document &$document) {
		$this->doFill();
		$this->doDisableAll();
		$document->html = $this->Form();
	}

	public function viewIndex(Document &$document) {
		$this->doFill();
		$this->doDisableAll();
		$document->html = $this->Form();
	}

}
        