<?

namespace view;

use DOMWrap\Document;
use FwHtml\Elements\Attrs\Style\Props\Target;
use FwHtml\Elements\Tags\Main\HtmlTags;
use FwHtml\FontAwesome;
use model\Entity\UsersEntity;
use View;

class Users extends View {

	public $SingularName = 'کاربر';
	public $PluralName = 'کاربران';

	public function main(Document &$document) {
		$document->html = $this->Html()->BreadCrumbs() . HtmlTags::Section('.content')
				->Content(
					HtmlTags::Div('.row')
						->Content(
							HtmlTags::Div('.col-md-12')->Content(
								HtmlTags::Div('.card.card-primary.card-outline')
									->Content(
										HtmlTags::Div('.card-header')
											->Content(
												$this->Html()->CardTitle(),
												$this->Html()->refresh()
											),
										HtmlTags::Div('.card-body.d-flex.flex-wrap')
											->Content(
												HtmlTags::Table('.table.table-bordered.table-striped')
													->Content(
														HtmlTags::Thead('.table-dark')
															->Content(
																HtmlTags::Tr()->Content(
																	HtmlTags::Th('ردیف')->Width('50'),
//                                                                    HtmlTags::Th('نام کامل'),
																	HtmlTags::Th('نام کاربری'),
																	HtmlTags::Th('شماره همراه'),
																	HtmlTags::Th('تاریخ ثبت نام'),
//                                                                    HtmlTags::Th('کیف پول'),
																	HtmlTags::Th('.no-sort عملیات')->Width('150'),
																)
															),
														HtmlTags::Tbody()
															->Content(
																$this->show([
																	'user_email',
																	'mobile',
																	'created_at',
																], false, true, false, true, function ($row) {
																	if ($row->is_locked == 1) {
																		return HtmlTags::A('.btn.btn-success.p-2.toggleBlock')->Content(
																			HtmlTags::I(".m-0.p-1")->Class(FontAwesome::Unlock())
																		)->Data_('status', 'unlock')
																			->Data_('id', $row->user_id)
																			->Data_('toggle', 'tooltip')
																			->Data_('placement', 'top')
																			->Target(Target::_Blank())
																			->Title('آنبلاک');
																	} else {
																		return HtmlTags::A('.btn.btn-danger.p-2.toggleBlock')->Content(
																			HtmlTags::I(".m-0.p-1")->Class(FontAwesome::Ban())
																		)->Data_('status', 'block')
																			->Data_('id', $row->user_id)
																			->Data_('toggle', 'tooltip')
																			->Data_('placement', 'top')
																			->Title('بلاک');
																	}
																},
                                                                function ($row){
                                                                    return HtmlTags::A('.btn.btn-success.p-2.changeMembership')->Content(
                                                                        HtmlTags::I(".m-0.p-1")->Class(FontAwesome::Registered())
                                                                    )->Data_('id', $row->user_id)
                                                                        ->Data_('toggle', 'tooltip')
                                                                        ->Data_('placement', 'top')
                                                                        ->Target(Target::_Blank())
                                                                        ->Title('تغییر عضویت');
                                                                })
															)
													)
											)
									)
							)
						)
				);
	}
    public function cardPayments(Document &$document) {
		$this->PluralName = "کارت به کارت";
		$document->html = $this->Html()->BreadCrumbs() . HtmlTags::Section('.content')
				->Content(
					HtmlTags::Div('.row')
						->Content(
							HtmlTags::Div('.col-md-12')->Content(
								HtmlTags::Div('.card.card-primary.card-outline')
									->Content(
										HtmlTags::Div('.card-header')
											->Content(
												$this->Html()->CardTitle(),
												$this->Html()->refresh()
											),
										HtmlTags::Div('.card-body.d-flex.flex-wrap')
											->Content(
												HtmlTags::Table('.table.table-bordered.table-striped')
													->Content(
														HtmlTags::Thead('.table-dark')
															->Content(
																HtmlTags::Tr()->Content(
																	HtmlTags::Th('ردیف')->Width('50'),
//                                                                    HtmlTags::Th('نام کامل'),
																	HtmlTags::Th('شماره همراه یا ایمیل'),
																	HtmlTags::Th('مبلغ پرداخت شده'),
																	HtmlTags::Th('تاریخ و ساعت'),
																	HtmlTags::Th('فیش واریزی'),
//                                                                    HtmlTags::Th('کیف پول'),
																	HtmlTags::Th('.no-sort عملیات')->Width('150'),
																)
															),
														HtmlTags::Tbody()
															->Content(
																$this->show([
																	'user_id'        => function ($userId) {
																		$user = \model\Users::get($userId);
																		if ($user instanceof UsersEntity) {

																			return $user->mobile . ' ' . $user->user_email . " " . ($user->membership_id > 0 ? ($user->membership_expired_at >= time() ? "با اشتراک" : "منقضی شده") : "");
																		}
																		return "$userId";
																	},
																	'payment_amount' => function ($amount) {
																		return price_format($amount / 10);
																	},
																	'payment_date'   => function ($date) {
																		return jdate("Y/m/d", $date);
																	},
																	'payment_data'   => function ($data) {
																		$data = json_decode($data);
																		if ($data) {
																			return HtmlTags::Img('.previewMe')->Src(__IMAGES__ . 'Payment/' . $data->receipt)->Attrs(['style' => 'height: 10rem']);
																		}
																		return "no receipt";
																	},
																], false, false, false, false, function ($row) {
																	if ($row->payment_status == 1) {
																		return "";
																	} else {
																		return HtmlTags::A('.btn.btn-success.p-2.confirmPayment')->Content(
																			HtmlTags::I(".m-0.p-1")->Class(FontAwesome::Check())
																		)->Data_('status', '1')
																			->Data_('id', $row->payment_id)
																			->Data_('toggle', 'tooltip')
																			->Data_('placement', 'top')
																			->Title('تایید پرداخت');
																	}
																}, function ($row) {
																	if ($row->payment_status == 1) {
																		return "";
																	} else {
																		return HtmlTags::A('.btn.btn-danger.mr-1.p-2.deletePayment')->Content(
																			HtmlTags::I(".m-0.p-1")->Class(FontAwesome::Trash())
																		)
																			->Data_('id', $row->payment_id)
																			->Data_('toggle', 'tooltip')
																			->Data_('placement', 'top')
																			->Title('حذف؟ مطمئن هستید؟');
																	}
																})
															)
													)
											)
									)
							)
						)
				);
	}
	public function cryptoPayments(Document &$document) {
		$this->PluralName = "ارز دیجیتال";
		$document->html = $this->Html()->BreadCrumbs() . HtmlTags::Section('.content')
				->Content(
					HtmlTags::Div('.row')
						->Content(
							HtmlTags::Div('.col-md-12')->Content(
								HtmlTags::Div('.card.card-primary.card-outline')
									->Content(
										HtmlTags::Div('.card-header')
											->Content(
												$this->Html()->CardTitle(),
												$this->Html()->refresh()
											),
										HtmlTags::Div('.card-body.d-flex.flex-wrap')
											->Content(
												HtmlTags::Table('.table.table-bordered.table-striped')
													->Content(
														HtmlTags::Thead('.table-dark')
															->Content(
																HtmlTags::Tr()->Content(
																	HtmlTags::Th('ردیف')->Width('50'),
//                                                                    HtmlTags::Th('نام کامل'),
																	HtmlTags::Th('شماره همراه یا ایمیل'),
																	HtmlTags::Th('مبلغ پرداخت شده'),
																	HtmlTags::Th('تاریخ و ساعت'),
																	HtmlTags::Th('فیش واریزی'),
//                                                                    HtmlTags::Th('کیف پول'),
																	HtmlTags::Th('.no-sort عملیات')->Width('150'),
																)
															),
														HtmlTags::Tbody()
															->Content(
																$this->show([
																	'user_id'        => function ($userId) {
																		$user = \model\Users::get($userId);
																		if ($user instanceof UsersEntity) {

																			return $user->mobile . ' ' . $user->user_email . " " . ($user->membership_id > 0 ? ($user->membership_expired_at >= time() ? "با اشتراک" : "منقضی شده") : "");
																		}
																		return "$userId";
																	},
																	'payment_amount' => function ($amount) {
																		return price_format($amount / 10);
																	},
																	'payment_date'   => function ($date) {
																		return jdate("Y/m/d", $date);
																	},
																	'payment_data'   => function ($data) {
																		$data = json_decode($data);
																		if ($data) {
																			return HtmlTags::Img('.previewMe')->Src(__IMAGES__ . 'Payment/' . $data->receipt)->Attrs(['style' => 'height: 10rem']);
																		}
																		return "no receipt";
																	},
																], false, false, false, false, function ($row) {
																	if ($row->payment_status == 1) {
																		return "";
																	} else {
																		return HtmlTags::A('.btn.btn-success.p-2.confirmPayment')->Content(
																			HtmlTags::I(".m-0.p-1")->Class(FontAwesome::Check())
																		)->Data_('status', '1')
																			->Data_('id', $row->payment_id)
																			->Data_('toggle', 'tooltip')
																			->Data_('placement', 'top')
																			->Title('تایید پرداخت');
																	}
																}, function ($row) {
																	if ($row->payment_status == 1) {
																		return "";
																	} else {
																		return HtmlTags::A('.btn.btn-danger.mr-1.p-2.deletePayment')->Content(
																			HtmlTags::I(".m-0.p-1")->Class(FontAwesome::Trash())
																		)
																			->Data_('id', $row->payment_id)
																			->Data_('toggle', 'tooltip')
																			->Data_('placement', 'top')
																			->Title('حذف؟ مطمئن هستید؟');
																	}
																})
															)
													)
											)
									)
							)
						)
				);
	}
    public function confirmDocs(Document &$document) {
        $this->PluralName = "تایید مدارک";
        $document->html = $this->Html()->BreadCrumbs() . HtmlTags::Section('.content')
                ->Content(
                    HtmlTags::Div('.row')
                        ->Content(
                            HtmlTags::Div('.col-md-12')->Content(
                                HtmlTags::Div('.card.card-primary.card-outline')
                                    ->Content(
                                        HtmlTags::Div('.card-header')
                                            ->Content(
                                                $this->Html()->CardTitle(),
                                                $this->Html()->refresh()
                                            ),
                                        HtmlTags::Div('.card-body.d-flex.flex-wrap')
                                            ->Content(
                                                HtmlTags::Table('.table.table-bordered.table-striped')
                                                    ->Content(
                                                        HtmlTags::Thead('.table-dark')
                                                            ->Content(
                                                                HtmlTags::Tr()->Content(
                                                                    HtmlTags::Th('ردیف')->Width('50'),
                                                                    HtmlTags::Th('نام کامل'),
                                                                    HtmlTags::Th('شماره همراه یا ایمیل'),
                                                                    HtmlTags::Th('وضعیت حساب کاربری'),
                                                                    HtmlTags::Th('.no-sort عملیات')->Width('150'),
                                                                )
                                                            ),
                                                        HtmlTags::Tbody()
                                                            ->Content(
                                                                $this->show([
                                                                    'user_name',
                                                                    'user_id'        => function ($userId) {
                                                                        $user = \model\Users::get($userId);
                                                                        if ($user instanceof UsersEntity) {
                                                                            return $user->mobile . ' ' . $user->user_email . " " . ($user->membership_id > 0 ? ($user->membership_expired_at >= time() ? "با اشتراک" : "منقضی شده") : "");
                                                                        }
                                                                        return "$userId";
                                                                    },
                                                                    'is_active' =>function($active){
                                                                        return $active == 1? "فعال":"غیرفعال";
                                                                    }
                                                                ], false, false, false, false, function ($row) {
                                                                    if ($row->is_active == 1){
                                                                        $status = "فعال";
                                                                    }else{
                                                                        $status = 'غیرفعال';
                                                                    }
                                                                    return HtmlTags::Button('.btn.btn-outline-primary.m-2.p-2.showArtistInfo')->Content(
                                                                        HtmlTags::I(".m-0.p-1")->Class(FontAwesome::Eye()),
                                                                    )->Data_('toggle', 'tooltip')
                                                                        ->Data_('placement', 'top')
                                                                        ->Data_('id', $row->user_id)
                                                                        ->Data_('status', $status)
                                                                        ->Title('نمایش مدارک');
                                                                })
                                                            )
                                                    )
                                            )
                                    )
                            )
                        )
                ) . $this->buildDocsModal();
    }

    private function buildDocsModal()
    {
        return HtmlTags::Div(".modal.fade#docsModal")->Content(
            HtmlTags::Div('.modal-dialog.modal-xl')->Content(
                HtmlTags::Div('.modal-content')->Content(
                    HtmlTags::Div('.modal-header')->Content(
                        HtmlTags::H4('.modal-title#docsModalTitle')->Content(),
                        HtmlTags::Div('.pull-left')->Content(
                            HtmlTags::Button('.close')->Content('&times;')->Data_('dismiss', 'modal')->Type('button')
                        )
                    ),
                    HtmlTags::Form()->Content(
                        HtmlTags::Div('.modal-body.d-flex.flex-wrap.justify-center')->Content(
                            HtmlTags::Div('.table-responsive')->Content(
                                HtmlTags::Table('.table.table-bordered.table-striped.w-100')->Content(
                                // محتوای جدول
                                )
                            )
                        )
                    )
                )
            )
        );

    }
    public function addIndex(Document &$document) {
		$document->html = $this->Form();
	}
	public function Form() {
		return $this->Html()->BreadCrumbs() . HtmlTags::Section('.content')
				->Content(
					HtmlTags::Div('.row')
						->Content(
							HtmlTags::Div('.col-md-12')->Content(
								HtmlTags::Div('.card.card-primary.card-outline')
									->Content(
										HtmlTags::Div('.card-header')
											->Content(
												$this->Html()->CardTitle(),
												$this->Html()->refreshAndBack()
											),
										$this->Html()->FormStart() .

										HtmlTags::Div('.alert.bg-dark.w-100')->Content('اطلاعات هویتی ') .

										$this->Html()->FormGroupStart(3) .
										$this->Html()->Label('نام') .
										$this->Html()->Input('user_name') .
										$this->Html()->FormGroupEnd() .

										$this->Html()->FormGroupStart(3) .
										$this->Html()->Label('شماره موبایل') .
										$this->Html()->Mobile('mobile') .
										$this->Html()->FormGroupEnd() .

										$this->Html()->FormGroupStart(3) .
										$this->Html()->Label('ایمیل') .
										$this->Html()->Email('user_email') .
										$this->Html()->FormGroupEnd() .

										$this->Html()->FormGroupStart(3) .
										$this->Html()->Label('تاریخ تولد') .
										$this->Html()->Date('birthdate') .
										$this->Html()->FormGroupEnd() .


										HtmlTags::Div('.alert.bg-dark.w-100')->Content('اطلاعات تکمیلی ') .

										$this->Html()->FormGroupStart(4) .
										$this->Html()->Label('انتخاب کشور') .
										$this->Html()->Select('country_id', 'country_id', \model\Countries::toOption()) .
										$this->Html()->FormGroupEnd() .
										$this->Html()->FormGroupStart(4) .
										$this->Html()->Label('انتخاب استان') .
										$this->Html()->Select('state_id', 'state_id', \model\States::toOption()) .
										$this->Html()->FormGroupEnd() .

										$this->Html()->FormGroupStart(4) .
										$this->Html()->Label('انتخاب شهر') .
										$this->Html()->Select('city_id', 'city_id', \model\Cities::toOption()) .
										$this->Html()->FormGroupEnd() .
//                                        $this->Html()->FormGroupStart(12) .
//                                        $this->Html()->Label('دسته بندی های مورد علاقه') .
//                                        $this->Html()->Select('user_categories[]', 'user_categories',\model\Categories::toOption(),true,false) .
//                                        $this->Html()->FormGroupEnd() .


//                                        $this->Html()->FormGroupStart() .
//                                        $this->Html()->Label('رشته تحصیلی') .
//                                        $this->Html()->Input('user_study_field','user_study_field','',false) .
//                                        $this->Html()->FormGroupEnd() .
//                                        $this->Html()->FormGroupStart() .
//                                        $this->Html()->Label('مقطع تحصیلی') .
//                                        $this->Html()->Input('user_study_degree','user_study_degree','',false) .
//                                        $this->Html()->FormGroupEnd() .


										HtmlTags::Div('.alert.bg-dark.w-100')->Content('اطلاعات حساب کاربری ') .
										$this->Html()->FormGroupStart() .
										$this->Html()->Label('جنسیت') .
										$this->Html()->Input('user_gender', 'user_gender', '', false) .
										$this->Html()->FormGroupEnd() .
										$this->Html()->FormGroupStart(4) .
										$this->Html()->Label('رمز عبور') .
										$this->Html()->Password('user_password') .
										$this->Html()->FormGroupEnd() .

										$this->Html()->FormGroupStart(4) .
										$this->Html()->Label('تصویر پروفایل (اختیاری)') .
										($this->State() == "add" ? $this->Html()->ImageInput('user_avatar', 'image/*', '150', '150', 'true', 'user_picture', false) : HtmlTags::Img()->Attrs(['style' => 'width: 50px;height: 50px'])->Src(is_file(__SOURCE__ . 'images/Users/' . $this->getData()->user_id . '.jpg') ? __IMAGES__ . '/Users/' . $this->getData()->user_id . '.jpg' : __IMAGES__ . '/Users/placeholder.jpg')),
										$this->Html()->FormGroupEnd() .

//                                        $this->Html()->FormGroupStart(4) .
//                                        $this->Html()->Label('کیف پول') .
//                                        $this->Html()->Price('user_credit') .
//                                        $this->Html()->FormGroupEnd() .


										$this->Html()->CardFooter()
									)
							)
						)
				);
	}
	public function editIndex(Document &$document) {
		$this->doFill();
		$document->html = $this->Form();
	}
	public function deleteIndex(Document &$document) {
		$this->doFill();
		$this->doDisableAll();
		$document->html = $this->Form();
	}
	public function viewIndex(Document &$document) {
		$this->doFill();
		$this->doDisableAll();
		$document->html = $this->Form();
	}

}
