<?php

namespace routes\v1;

use DATABASE\ORM\QueryBuilder\QueryBuilder\Db;
use FwRoutingSystem\Router;
use model\Entity\AudioBooksEntity;
use model\Entity\BookmarksEntity;
use model\Entity\MembershipsEntity;
use model\Entity\StoriesEntity;
use model\Entity\UsersEntity;
use model\Memberships;
use model\Users;
use version\ApiVersions;

class AudioBookRoute extends \Api\BaseRouter {
	public string $version = ApiVersions::one;
	public $groupPath = 'audioBook';

	public function routes(Router $router) {

		$router->post('/bookmark/:id', $this->middleware($router), function ($storyId) {
			$user = Users::findToken(get_header('auth'));
			$story = \model\AudioBooks::get($storyId);
			if ($story instanceof AudioBooksEntity) {
				$bookmark = \model\Bookmarks::Db()->where('user_id', $user->user_id)->where('audio_book_id', $storyId)->get()->first;
				if ($bookmark instanceof BookmarksEntity) {
					if (\model\Bookmarks::delete($bookmark->bookmark_id)) {
						return response([
							'message' => "داستان از لیست بوک مارک ها حذف شد"
						]);
					} else {
						return response([
							'خطا در پردازش اطلاعات'
						], 400);
					}
				} else {
					if (\model\Bookmarks::add([
						'user_id'  => $user->user_id,
						'audio_book_id' => $storyId
					])) {
						return response([
							'message' => "داستان به لیست بوک مارک ها اضافه شد"
						]);
					} else {
						return response([
							'خطا در پردازش اطلاعات'
						], 400);
					}
				}
			}
			return response([
				'message' => "داستان پیدا نشد"
			], 404);
		});

		$router->get('/audioBook/:id', function ($id) {
			$audio = \model\AudioBooks::get($id);
			if ($audio instanceof AudioBooksEntity) {
				$bookmark = null;
				$user = Users::findToken(get_header('auth'));

				if ($user instanceof UsersEntity) {
					$bookmark = \model\Bookmarks::Db()->where('user_id', $user->user_id)->where('audio_book_id', $id)->get()->first;
					$plan = Memberships::get($user->membership_id);
					if (($plan instanceof MembershipsEntity and !in_array($id, json_decode($plan->audio_book_ids, true) ?? [])) or $plan == null or $user->membership_expired_at <= time()) {
						return response(['message' => "شما به این کتاب صوتی دسترسی ندارید!"], 404);
					}
				} else {
					return response(['message' => "شما به این کتاب صوتی دسترسی ندارید!"], 404);
				}

				return response(['audioBook' => $audio->singleApiFormat($bookmark instanceof BookmarksEntity),]);

			}
			return response(['message' => "کتاب صوتی یافت نشد"], 404);

		});

	}

	public function requiredHeaders(): array {
		return $this->auth();
	}

}
