<?php

namespace routes\v1;

use FwRoutingSystem\Router;
use model\Entity\SettingsEntity;
use model\Entity\UsersEntity;
use model\Entity\UserTempsEntity;
use model\Messages;
use model\Settings;
use model\UserAddresses;
use model\Users;
use model\UserTemps;
use PHPMailer\PHPMailer\Exception;
use version\ApiVersions;

class AuthRoute extends \Api\BaseRouter {
	public string $version = ApiVersions::one;
	public $groupPath = 'auth';

	public function routes(Router $router) {
		$router->post('/add-address', $this->middleware($router), function () {
			$title = $this->getParam('title');
			$address = $this->getParam('address');
			$plaque = $this->getParam('plaque');
			$zipCode = $this->getParam('zipCode', false) ?? "";
			$user = Users::findToken(get_header('auth'));

			if (UserAddresses::add([
				'user_id'               => $user->user_id,
				'user_address_name'     => $title,
				'user_address_text'     => $address,
				'user_address_floor'    => "$plaque",
				'user_address_zip_code' => "$zipCode",
				'user_address_phone'    => "",
			])) {
				return response(['message' => "آدرس با موفقیت ثبت شد!",],);
			} else {
				return response(['message' => "خطایی در ذخیره آدرس بوجود آمد",], 400);
			}
		});
		$router->post('/delete-address/:id', $this->middleware($router), function ($id) {
			$user = Users::findToken(get_header('auth'));

			if (UserAddresses::delete($id)) {
				return response(['message' => "آدرس با موفقیت حذف شد!",],);
			} else {
				return response(['message' => "خطایی در حذف آدرس بوجود آمد",], 400);
			}
		});
		$router->post('/init', function () {
			$mobile = $this->getParam('mobile');
			$user = Users::byMobile($mobile);

			$temp = UserTemps::getOneFiltered('mobile', $mobile);
			if ($temp) {
				UserTemps::delete($temp->user_temp_id);
			}
			$code = rand(1000, 9999);
			sendVerify($mobile, [
				$code,
			]);
			if (UserTemps::add([
				'mobile'    => $mobile,
				'user_code' => $code,
			])) {
				return response([
					'type'    => $user instanceof UsersEntity ? 'login' : 'register',
					'message' => 'کد ورود از طریق پیامک برای شما ارسال شد',
				]);
			}
			return response([
				'type'    => 'error',
				'message' => 'خطایی در فرآیند احراز هویت رخ داد',
			], 400);
		});
		$router->post('/init2', function () {
			$mobileEmail = fa_to_en($this->getParam('mobileEmail'));
			$isEmail = $this->getParam('isEmail') == 1;
			if ($isEmail) {
				$user = Users::byMail($mobileEmail);
			} else {
				$user = Users::byMobile($mobileEmail);
			}


			$temp = UserTemps::getOneFiltered('mobile', $mobileEmail);
			if ($temp) {
				UserTemps::delete($temp->user_temp_id);
			}
			$code = rand(1000, 9999);
			$res = "";

			if ($isEmail) {
				ob_start();
				include __SOURCE__ . "dist/php/PHPMailer/template/verify.php";
				$content = ob_get_clean();
				$res = send_mail_by_PHPMailer($mobileEmail, "nahid@lexaplus.com", "کد تایید اپلیکیشن نوشته های ناهید", $content);
			} else {
				try {

					[
						$success,
						$res
					] = sendSmsPattern($mobileEmail, 250275, ["$code"]);
					if (!$success) {
						return response([
							'message' => "پنل پیامکی در دسترس نمی باشد، تا ساعاتی دیگر مشکل رفع خواهد شد. ",
						], 400);
					}
				} catch (Exception $exception) {
					return response([
						'info'    => $exception->getMessage(),
						'message' => "کد وارد شده اشتباه است",
					], 400);
				}
			}
			if (UserTemps::add([
				'mobile'    => $mobileEmail,
				'user_code' => $code,
			])) {
				return response([
					'res'     => $res,
					'type'    => $user instanceof UsersEntity ? 'login' : 'register',
					'message' => 'لطفا کد تایید را وارد کنید',
				]);
			}

			return response([
				'type'    => 'error',
				'message' => 'خطایی در فرآیند احراز هویت رخ داد',
			], 400);
		});
		$router->post('/forgot', function () {
			$mobile = $this->getParam('mobile');
			$user = Users::byMobile($mobile);
			if ($user instanceof UsersEntity) {
				$temp = UserTemps::getOneFiltered('mobile', $mobile);
				if ($temp) {
					UserTemps::delete($temp->user_temp_id);
				}
				$code = rand(1000, 9999);
				sendVerify($mobile, [$code]);
				if (UserTemps::add([
					'mobile'    => $mobile,
					'user_code' => $code,
				])) {
					return response([
						'message' => 'کد ورود از طریق پیامک برای شما ارسال شد',
					]);
				} else {

					return response([
						'message' => 'خطایی رخ داد',
					], 400);
				}
			} else {
				return response([
					'type'    => 'error',
					'message' => 'شماره وارد شده یافت نشد!',
				], 404);
			}
		});
		$router->post('/validate', function () {
			$mobile = $this->getParam('mobile');
			$code = $this->getParam('code');
//            $fToken = $this->getParam('token');

			$temp = UserTemps::getOneFiltered('mobile', $mobile);
			if ($temp and $temp->user_code == $code) {
				$user = Users::byMobile($mobile);
				$token = md5(time());

				if ($user instanceof UsersEntity) {
					if (Users::edit($user->user_id, [
						'login_date'     => time(),
						'last_seen_date' => time(),
						'token'          => $token,
						//                        'firebase_token' => $fToken,
					])) {
						UserTemps::delete($temp->user_temp_id);
						return response([
							'message' => "خوش آمدید!",
							'type'    => 'login',
							'user'    => $user->apiFormat(),
							'token'   => $token,
						]);
					}
				} else {
					if ($id = Users::add([
						'mobile'         => $mobile,
						'login_date'     => time(),
						'last_seen_date' => time(),
						'token'          => $token,
						//                        'firebase_token' => $fToken,
					])) {
						$user = Users::get($id);
						UserTemps::delete($temp->user_temp_id);
						return response([
							'message' => "خوش آمدید!",
							'type'    => 'login',
							'user'    => $user->apiFormat(),
							'token'   => $token,
						]);
					}
					return response([
						'message' => "لطفا اطلاعات خود را وارد کنید",
						'type'    => 'register',
					]);
				}
			}
			return response([
				'message' => "کد وارد شده اشتباه است",
			], 400);
		});
		$router->post('/validate2', function () {
			$mobile = fa_to_en($this->getParam('mobileEmail'));
			$code = $this->getParam('code');
//			return response([
//				'message' => "کد وارد شده اشتباه است ",
//			], 400);
			$temp = UserTemps::getOneFiltered('mobile', $mobile);
			if (($temp and $temp->user_code == $code) or ($mobile == 'b_rashedi@yahoo.com' and $code == 1727)) {
				$isEmail = false;
				if (filter_var($mobile, FILTER_VALIDATE_EMAIL)) {
					$isEmail = true;
					$user = Users::byMail($mobile);
				} else {
					$user = Users::byMobile($mobile);
				}
				$token = md5(time());

				if ($user instanceof UsersEntity) {
					if (Users::edit($user->user_id, [
						'login_date'     => time(),
						'last_seen_date' => time(),
						'token'          => $token,
						//                        'firebase_token' => $fToken,
					])) {
						UserTemps::delete($temp->user_temp_id);
						return response([
							'message' => "خوش آمدید!",
							'type'    => 'login',
							'user'    => $user->apiFormat(),
							'token'   => $token,
						]);
					}
				} else {
					do {
						$referrerCode = generateRandomString();
						$existingUser = Users::getOneFiltered('user_referrer',$referrerCode);
					} while ($existingUser);
					$userArr = [
						'login_date'     => time(),
						'last_seen_date' => time(),
						'token'          => $token,
						'user_referrer' => $referrerCode
//						                        'firebase_token' => $fToken,
					];
					if ($isEmail) {
						$userArr['user_email'] = $mobile;
					} else {
						$userArr['mobile'] = $mobile;
					}
					if ($id = Users::add($userArr)) {
						$user = Users::get($id);
						UserTemps::delete($temp->user_temp_id);
						return response([
							'message' => "خوش آمدید!",
							'type'    => 'register',
							'user'    => $user->apiFormat(),
							'token'   => $token,
						]);
					}
					return response([
						'message' => "لطفا اطلاعات خود را وارد کنید",
						'type'    => 'register',
					]);
				}
			}
			return response([
				'message' => "کد وارد شده اشتباه است",
			], 400);
		});

		$router->any('/check', function () {
			$user = Users::findToken(get_header('auth'));
			$version = $this->getParam('version');
			if ($version != '1.0.3' and false) {
				return response([
					'type'    => 'version',
					'link'    => 'https://app.nahid-golkar.ir/Nahid-v4.apk',
					'isForce' => false,
				], 400);
			}
			if ($user instanceof UsersEntity) {
				Users::edit($user->user_id, [
					'version' => $version,
				]);
				return response([
					'message' => 'ok',
					'user'    => $user->apiFormat(),
				], 201);
			} else {
				return response([
					'message' => 'User not found',
				], 403);
			}
		});
		$router->post('/update-profile', $this->middleware($router), function () {
			$user = Users::findToken(get_header('auth'));

			$name = $this->getParam('name');
			$bio = $this->getParam('bio');
			if (Users::edit($user->user_id, [
				'user_name' => $name,
				'user_bio'  => $bio,
			])) {
				$user = Users::findToken(get_header('auth'));
				return response([
					'user'    => $user->apiFormat(),
					'message' => 'تغییرات پروفایل با موفقیت ذخیره شد.',
				]);
			}
			return response([
				'message' => 'ذخیره تغییرات با خطا مواجه شد',
			], 400);
		});
		$router->post('/update-image', $this->middleware($router), function () {
			$user = Users::findToken(get_header('auth'));
			$image = base64_decode($this->getParam('image'));
			if (file_put_contents(__SOURCE__ . 'images/Users/' . $user->user_id . '.jpg', $image)) {
				if ($user instanceof UsersEntity) {
					Users::edit($user->user_id, [
						'image' => $user->user_id . '.jpg',
					]);
					return response([
						'path' => __IMAGES__ . 'Users/' . $user->user_id . '.jpg',
					], 201);
				} else {
					return response([
						'message' => 'User not found',
					], 403);
				}
			}
			return response([
				'message' => 'Upload failed',
			], 400);
		});
		$router->post('/login', function () {
			$mobile = $this->getParam('mobile');
			$password = $this->getParam('password');
//			$fToken = $this->getParam('token');

			$temp = UserTemps::getOneFiltered('mobile', $mobile);
			if ($temp and $temp->user_code == $password) {
				$user = Users::byMobile($mobile);
				if ($user instanceof UsersEntity) {
					$token = md5(time());
					if (Users::edit($user->user_id, [
						'login_date' => time(),
						'token'      => $token,
						//						'firebase_token' => $fToken,
					]))
						return response([
							'message' => "خوش آمدید!",
							'type'    => 'login',
							'user'    => $user->apiFormat(),
							'token'   => $token,
						]);
				} else {
					return response([
						'message' => "خطایی رخ داد",
					], 404);
				}
			}

			return response([
				'message' => "کد وارد شده اشتباه است",
			], 400);
		});
		$router->post('/login2', function () {
			$mobileEmail = fa_to_en($this->getParam('mobileEmail'));
			$password = $this->getParam('password');
//			$fToken = $this->getParam('token');

			$temp = UserTemps::getOneFiltered('mobile', $mobileEmail);
			if ($temp and $temp->user_code == $password) {
				$isEmail = filter_var($mobileEmail, FILTER_VALIDATE_EMAIL) !== false;
				if ($isEmail) {
					$user = Users::byMail($mobileEmail);
				} else {
					$user = Users::byMobile($mobileEmail);
				}
				if ($user instanceof UsersEntity) {
					$token = md5(time());
					if (Users::edit($user->user_id, [
						'login_date' => time(),
						'token'      => $token,
						//						'firebase_token' => $fToken,
					]))
						return response([
							'message' => "خوش آمدید!",
							'type'    => 'login',
							'user'    => $user->apiFormat(),
							'token'   => $token,
						]);
				} else {
					return response([
						'message' => "خطایی رخ داد",
					], 404);
				}
			}

			return response([
				'message' => "کد وارد شده اشتباه است",
			], 400);
		});
		$router->post('/register', function () {
			$mobile = $this->getParam('mobile');
			$code = $this->getParam('code');

			$user = UserTemps::getOneFiltered('mobile', $mobile);
			if ($user and $user->user_code == $code) {
				$token = md5(time());



				do {
					$referrerCode = generateRandomString();
					$existingUser = Users::getOneFiltered('user_referrer',$referrerCode);
				} while ($existingUser);



				if (Users::add([
					'mobile'     => $mobile,
					'login_date' => time(),
					'token'      => $token,

					'user_referrer' => $referrerCode
				])) {
					$user = Users::byToken($token);
					if ($user instanceof UsersEntity) {
						return response([
							'user'  => $user->apiFormat(),
							'token' => $token,
						]);
					} else {
						return response([
							'message' => 'خطایی در ذخیره رخ داد'
						], 400);
					}
				}
			}

			return response([
				'message' => 'خطایی در ذخیره رخ داد'
			], 400);
		});
	}

	public function requiredHeaders(): array {
		return $this->auth();
	}

	private function register($username) {
		$password = $this->getParam('password');
		$token = $this->getParam('token');
		$isMobile = !$this->getParam('isEmail');
		if ($isMobile) {
			$user = Users::getOneFiltered('mobile', $username);
		} else {
			$user = Users::getOneFiltered('user_email', $username);
		}
		$userTemp = UserTemps::getOneFiltered('user_email', $username);
		if ($userTemp instanceof UserTempsEntity) {
			UserTemps::delete($userTemp->user_temp_id);
		}
		if ($user instanceof UsersEntity) {
			return response([
				'message' => 'Username already taken'
			], 404);
		} else {
			$addArray = [
				'user_password'  => sha1(md5($password)),
				'login_date'     => time(),
				'token'          => md5(date("Y/m/d-H:i:u")),
				'firebase_token' => $token,
			];
			if ($isMobile) {
				$addArray['mobile'] = $username;
			} else {
				$addArray['user_email'] = $username;
			}
			$code = rand(1000, 9999);


			if (mail($username, 'Omigra Authentication Code', "Your otp code is: $code")) {
				if ($id = UserTemps::add([
					'user_data'  => json_encode($addArray),
					'user_code'  => $code,
					'user_email' => $username,
				])) {
					if ($password != 'arJuuHtHtTwN5gxFy5Pp' and !$isMobile) {
						$code = '0000';
					}
					return response([
						'type'    => 'register',
						'message' => "OTP sent successfully!: $code",
						'code'    => $code,
					], 200);
				} else {
					return response([
						'message' => 'Add user failed'
					], 400);
				}
			} else {
				return response([
					'message' => 'Failed to send email'
				], 400);
			}
		}
	}

}
