<?php

namespace routes\v1;

use fwJson\Json;
use FwRoutingSystem\Router;
use model\Books;
use model\Comments;
use model\Entity\BookmarksEntity;
use model\Entity\BooksEntity;
use model\Entity\DiscountsEntity;
use model\Entity\OrdersEntity;
use model\Entity\PlansEntity;
use model\Entity\UserAddressesEntity;
use model\Entity\UsersEntity;
use model\PaymentTable;
use model\Plans;
use model\Transactions;
use model\UserAddresses;
use model\Users;
use site\helpers\IranPayment;
use site\helpers\ZarinPalPayment;
use version\ApiVersions;

class BookRoute extends \Api\BaseRouter {
	public string $version = ApiVersions::one;
	public $groupPath = 'books';

	public function routes(Router $router) {
		$router->get('/book/:id', function ($id) {
			$book = Books::get($id);
			if ($book instanceof BooksEntity) {
				$user = Users::findToken(get_header('auth'));
				$isBookmarked = false;
				if ($user instanceof UsersEntity) {
					$isBookmarked = \model\Bookmarks::Db()->where('user_id', $user->user_id)->where('book_id', $id)->get()->first instanceof BookmarksEntity;
				}
				return response([
					'book' => $book->apiFormat($isBookmarked),
				]);
			} else {
				return response([
					'message' => "کتاب یافت نشد!",
				], 404);
			}
		});

		$router->post('/comment/:id', $this->middleware($router), function ($bookId) {
			$user = Users::findToken(get_header('auth'));
			$rate = $this->getParam('rate');
			$text = $this->getParam('text');
			$book = \model\Stories::get($bookId);
			if ($book instanceof BooksEntity) {
				if (Comments::add([
					'story_id'     => $book->book_id,
					'comment_rate' => $rate,
					'comment_text' => $text,
					'user_id'      => $user->user_id,
				])) {
					return response([
						'message' => "نظر شما ثبت شد",
					]);
				} else {
					return response([
						'message' => "خطا در ذخیره نظر"
					], 400);
				}
			}
			return response([
				'message' => "داستان پیدا نشد"
			], 404);
		});

		$router->group('/order', function (Router $router) {
			$router->get('/list', $this->middleware($router), function () {
				$user = Users::findToken(get_header('auth'));
				$orders = \model\Orders::Db()->where('user_id', $user->user_id)->orderBy('created_at', true)->get()->map(function (OrdersEntity $ordersEntity) {
					return $ordersEntity->fullFormat();
				});
				return response($orders->values());
			});
			$router->get('/track/:id', $this->middleware($router), function ($orderId) {
				$user = Users::findToken(get_header('auth'));
				$order = \model\Orders::get($orderId);
				if ($order instanceof OrdersEntity) {
					if ($order->user_id == $user->user_id) {
						return response($order->fullFormat(), 200);
					} else {
						return response([
							'message' => "User not permitted"
						], 404);
					}
				}
				return response([
					'message' => "Order not found"
				], 404);
			});
			$router->post('/submit', $this->middleware($router), function () {
				$user = Users::findToken(get_header('auth'));
				$addressId = $this->getParam('addressId');
				$fee = 50000;
				$address = UserAddresses::get($addressId);
				if ($address instanceof UserAddressesEntity) {
//					$paymentType = $this->getParam('paymentType');
					$products = json_decode($this->getParam('books'), true);
					$discountCode = $this->getParam('couponCode');
					$total = 0;
					/** @var BooksEntity $product */
					foreach ($products as $id => $count) {
						$product = Books::get($id);
						$total += $product->price * $count;
					}
					$payable = $total + $fee;
					$discount = 0;
					$discountCode = \model\Discounts::Db()->where('discount_code', 'like', "$discountCode")->get();

					if ($discountCode->length() > 0 and $discountCode->first instanceof DiscountsEntity) {
						$number = \model\DiscountUses::Db()->where('discount_id', $discountCode->discount_id)->rowCount();
						$use = \model\DiscountUses::Db()->where('discount_id', $discountCode->discount_id)->where('user_id', $user->user_id,)->rowCount();
						if ($number < $discountCode->number and $use < $discountCode->use and $discountCode->expire_date > time()) {
							switch ($discountCode->type) {
								case 'price':
									$discount = $discountCode->amount;
									break;
								case 'percent':
									$discount = $payable * $discountCode->amount / 100;
									break;
							}
						}
					}
					if ($id = \model\Orders::add([
						'user_id'         => $user->user_id,
						'user_address_id' => $addressId,
						'book_id'         => json_encode($products),
						'order_fee'       => $fee,
						'order_discount'  => $discount,
						'order_total'     => $total,
						'order_payable'   => $payable - $discount,
					])) {
						$payment = new ZarinPalPayment();
						$payment->Type("buyBooks");
						$payment = $payment->initPayment(new PaymentTable())->UserModel(new Users(), $user)->Amount($total + $fee);
						$payment->OrderData(Json::encode([
							'orderId'   => $id,
							'userId'    => $user->user_id,
							'addressId' => $address->user_address_id,
						]));
						return response([
							'pay'     => $payment->goToPayment(),
							'message' => "سفارش با موفقیت ثبت شد",
							'id'      => $id,
						], 200);
					} else {
						return response([
							'message' => "خطا در ثبت سفارش"
						], 400);
					}
				} else {
					return response([
						'message' => "آدرس پیدا نشد"
					], 404);
				}
			});
		});

		$router->post('/bookmark/:id', $this->middleware($router), function ($bookId) {
			$user = Users::findToken(get_header('auth'));
			$book = \model\Books::get($bookId);
			if ($book instanceof BooksEntity) {
				$bookmark = \model\Bookmarks::Db()->where('user_id', $user->user_id)->where('book_id', $bookId)->get()->first;
				if ($bookmark instanceof BookmarksEntity) {
					if (\model\Bookmarks::delete($bookmark->bookmark_id)) {
						return response([
							'message' => "کتاب از لیست بوک مارک ها حذف شد"
						]);
					} else {
						return response([
							'message' => 'خطا در پردازش اطلاعات'
						], 400);
					}
				} else {
					if (\model\Bookmarks::add([
						'user_id' => $user->user_id,
						'book_id' => $bookId
					])) {
						return response([
							'message' => "کتاب به لیست بوک مارک ها اضافه شد"
						]);
					} else {
						return response([
							'message' => 'خطا در پردازش اطلاعات'
						], 400);
					}
				}
			}
			return response([
				'message' => "کتاب پیدا نشد"
			], 404);
		});

	}

	public function requiredHeaders(): array {
		return $this->auth();
	}

}
