<?php

namespace routes\v1;

use DATABASE\ORM\QueryBuilder\QueryBuilder\Db;
use fwJson\Json;
use FwRoutingSystem\Router;
use PHPMailer\PHPMailer\Exception;
use version\ApiVersions;


class BotRoute extends \Api\BaseRouter {
    public string $version = ApiVersions::one;
    public $groupPath = 'bot';
    public string $botToken = "7980066978:AAEl_s-8BUhmwFR_TGBxztymZYpW05EhuFA";

    public string $telegramApiUrl = "https://api.telegram.org/bot";

    public function routes(Router $router) {

        $router->any('/', function () {

            try {
                $body = file_get_contents('php://input');

                if (is_string($body)) {

                    try {

                        $body = json_decode($body, TRUE);
                    } catch (Exception$exception) {
                        return response(['parse error']);
                    }

                    if (is_array($body) and isset($body['message'])) {
                        $chatId = $body['message']['chat']['id'];
                        $messageText = $body['message']['text'];

                        // When the user sends /start
                        if ($messageText == "/start") {
                            $responseMessage = "Hello! Welcome to the bot.";
                            $this->sendMessage($chatId, $responseMessage);

                        }
                    }
                    return response(["$body is null"]);

                }
            } catch (Exception$exception) {
                return response([]);
            }
            return response([]);

        });

    }

    public function sendMessage($chatId, $messageText) {
        $data = [
            'chat_id' => $chatId,
            'text' => $messageText
        ];
        $res = CallAPI("POST",$this->telegramApiUrl.$this->botToken.'/sendMessage',$data,[
            'Content-type' => 'multipart/form-data'
        ]);
        Db::table('tblApiRequests')->insert([
                                                'ip'      => getIp(),
                                                'route'   => "BOT RES",
                                                'headers' => json_encode(getallheaders()),
                                                'body'    => $res,

                                            ]);
    }

    public function requiredHeaders(): array {
        return $this->auth();
    }

}
