<?php

namespace routes\v2;

use Api\BaseRouter;
use fwJson\Json;
use FwRoutingSystem\Router;
use model\Bookmarks;
use model\DiscountUses;
use model\Entity\AudioBooksEntity;
use model\Entity\BooksEntity;
use model\Entity\CommentsEntity;
use model\Entity\DiscountsEntity;
use model\Entity\EventsEntity;
use model\Entity\MembershipsEntity;
use model\Entity\PoemsEntity;
use model\Entity\StoriesEntity;
use model\Events;
use model\Likes;
use model\Memberships;
use model\PaymentTable;
use model\Points;
use model\Scores;
use model\Users;
use payment\BasePayment;
use site\helpers\ZarinPalPayment;
use version\ApiVersions;

class  ActionsRoute extends BaseRouter {

	public string $version = ApiVersions::two;
	public $groupPath = 'actions';

	public function routes(Router $router) {
		$router->post('/event/participate/:id', $this->middleware($router), function ($id) {
			$event = Events::get($id);
			$user = Users::findToken(get_header('auth'));
			$paymentType = $this->getParam('paymentType', false) ?? 2;
			$count = $this->getParam('count');

			if ($event instanceof EventsEntity) {

				$price = $event->entry_price * $count;
				switch ($paymentType) {
					case 2:

						$payment = new ZarinPalPayment();
						$payment->initPayment(new PaymentTable());
						$payment->UserModel(new Users(), $user);
						$payment->_amount = $price * 10;
						$payment->Type('event_registration');
						$payment->OrderData(Json::encode([
							'eventId' => $event->event_id,
							'userId'  => $user->user_id,
							'count'   => $count,
						]));
						$result = $payment->goToPayment();
						if (filter_var($result, FILTER_VALIDATE_URL)) {
							return response(['pay' => $result]);
						} else {
							return response(['message' => $result], 400,);
						}
					case 3:
						$image = base64_decode($this->getParam('receipt'));
						$name = time() . '.jpg';
						$res = file_put_contents(__SOURCE__ . 'images/Payment/' . $name, $image);
						if ($res > 0) {
							if (PaymentTable::add([
								'user_id'        => $user->user_id,
								'payment_amount' => $price * 10,
								'payment_resnum' => BasePayment::_createResnum('payment_resnum'),
								'payment_date'   => time(),
								'payment_type'   => 'event_registration_card',
								'payment_gate'   => 'کارت به کارت',
								'payment_data'   => json_encode([
									'receipt' => $name,
									'eventId' => $event->event_id,
									'count'   => $count,
									'userId'  => $user->user_id,
								]),
								'payment_from'   => "app",
							])) {
								return response([
									'message' => "رسید با موفقیت ذخیره شد، نام نویسی بعد از بررسی فیش واریزی فعال خواهد شد."
								]);
							} else {
								unlink(__SOURCE__ . 'images/Payment/' . $name);
								return response([
									'message' => "خطایی در ذخیره سازی رسید رخ داد"
								], 400);
							}
						} else {
							return response([
								'message' => "خطایی در آپلود رسید رخ داد"
							], 404);
						}
						break;
					case 4:
						$image = base64_decode($this->getParam('receipt'));
						$name = time() . '.jpg';
						$res = file_put_contents(__SOURCE__ . 'images/Payment/' . $name, $image);
						if ($res > 0) {
							if (PaymentTable::add([
								'user_id'        => $user->user_id,
								'payment_amount' => $price * 10,
								'payment_resnum' => BasePayment::_createResnum('payment_resnum'),
								'payment_date'   => time(),
								'payment_type'   => 'event_registration_crypto',
								'payment_gate'   => 'کریپتو',
								'payment_data'   => json_encode([
									'receipt' => $name,
									'eventId' => $event->event_id,
									'userId'  => $user->user_id,
									'count'   => $count,
								]),
								'payment_from'   => "app",
							])) {
								return response([
									'message' => "رسید با موفقیت ذخیره شد، نام نویسی بعد از بررسی فیش واریزی فعال خواهد شد."
								]);
							} else {
								unlink(__SOURCE__ . 'images/Payment/' . $name);
								return response([
									'message' => "خطایی در ذخیره سازی رسید رخ داد"
								], 400);
							}
						} else {
							return response([
								'message' => "خطایی در آپلود رسید رخ داد"
							], 404);
						}
						break;
				}

			} else {
				return response([
					'message' => "اشتراک یافت نشد! لطفا یک اشتراک را انتخاب کنید"
				], 404);
			}
		});

		$router->post('/buyPlan/:id', $this->middleware($router), function ($id) {
			$membership = Memberships::get($id);
			$user = Users::findToken(get_header('auth'));
			$code = $this->getParam('code', false);
			$paymentType = $this->getParam('paymentType', false) ?? 2;
//			return response([
//				'message' => "امکان خرید اشتراک میسر نمی باشد"
//			], 404);
			$code = "";
			if ($membership instanceof MembershipsEntity) {

				$price = $membership->price;
				$discountCode = \model\Discounts::Db()->where('discount_code', 'like', "$code")->get()->first;
				if ($discountCode instanceof DiscountsEntity) {
					$number = DiscountUses::Db()->where('discount_id', $discountCode->discount_id)->rowCount();
					$use = DiscountUses::Db()->where('discount_id', $discountCode->discount_id)->where('user_id', $user->user_id,)->rowCount();
					if ($number < $discountCode->number and $use < $discountCode->use) {
						switch ($discountCode->type) {
							case "1":
								$price = ($price - intval($price * $discountCode->amount / 100));
								break;
							case "2":
								$price = ($price - intval($discountCode->amount));
								break;
						}
					}
				}
				switch ($paymentType) {

					case 2:

						$payment = new ZarinPalPayment();
						$payment->initPayment(new PaymentTable());
						$payment->UserModel(new Users(), $user);
						$payment->_amount = $price * 10;
						$payment->Type('buyPlan');
						$payment->OrderData(Json::encode([
							'membershipId'   => $membership->membership_id,
							'userId'         => $user->user_id,
							'discountCode'   => $code,
							'discountAmount' => $membership->price - $price,
						]));
						$result = $payment->goToPayment();
						if (filter_var($result, FILTER_VALIDATE_URL)) {
							return response(['pay' => $result]);
						} else {
							return response(['message' => $result], 400,);
						}
					case 3:
						$image = base64_decode($this->getParam('receipt'));
						$name = time() . '.jpg';
						$res = file_put_contents(__SOURCE__ . 'images/Payment/' . $name, $image);
						if ($res > 0) {
							if (PaymentTable::add([
								'user_id'        => $user->user_id,
								'payment_amount' => $price * 10,
								'payment_resnum' => BasePayment::_createResnum('payment_resnum'),
								'payment_date'   => time(),
								'payment_type'   => 'buyPlan_card',
								'payment_gate'   => 'کارت به کارت',
								'payment_data'   => json_encode([
									'receipt'        => $name,
									'membershipId'   => $membership->membership_id,
									'userId'         => $user->user_id,
									'discountCode'   => $code,
									'discountAmount' => $membership->price - $price,
								]),
								'payment_from'   => "app",
							])) {
								return response([
									'message' => "رسید با موفقیت ذخیره شد، اشتراک شما بعد از بررسی فیش واریزی فعال خواهد شد."
								]);
							} else {
								unlink(__SOURCE__ . 'images/Payment/' . $name);
								return response([
									'message' => "خطایی در ذخیره سازی رسید رخ داد"
								], 400);
							}
						} else {
							return response([
								'message' => "خطایی در آپلود رسید رخ داد"
							], 404);
						}
						break;
					case 4:
						$image = base64_decode($this->getParam('receipt'));
						$name = time() . '.jpg';
						$res = file_put_contents(__SOURCE__ . 'images/Payment/' . $name, $image);
						if ($res > 0) {
							if (PaymentTable::add([
								'user_id'        => $user->user_id,
								'payment_amount' => $price * 10,
								'payment_resnum' => BasePayment::_createResnum('payment_resnum'),
								'payment_date'   => time(),
								'payment_type'   => 'buyPlan_crypto',
								'payment_gate'   => 'کریپتو',
								'payment_data'   => json_encode([
									'receipt'        => $name,
									'membershipId'   => $membership->membership_id,
									'userId'         => $user->user_id,
									'discountCode'   => $code,
									'discountAmount' => $membership->price - $price,
								]),
								'payment_from'   => "app",
							])) {
								return response([
									'message' => "رسید با موفقیت ذخیره شد، اشتراک شما بعد از بررسی فیش واریزی فعال خواهد شد."
								]);
							} else {
								unlink(__SOURCE__ . 'images/Payment/' . $name);
								return response([
									'message' => "خطایی در ذخیره سازی رسید رخ داد"
								], 400);
							}
						} else {
							return response([
								'message' => "خطایی در آپلود رسید رخ داد"
							], 404);
						}
						break;
				}

			} else {
				return response([
					'message' => "اشتراک یافت نشد! لطفا یک اشتراک را انتخاب کنید"
				], 404);
			}
		});
		$router->post('/comment/:id', $this->middleware($router), function ($episodeId = 0) {
			$user = Users::findToken(get_header('auth'));
			$text = $this->getParam('text');
			$id = $this->getParam('content_id');
			$type = $this->getParam('type');
			switch ($type) {
				case "story":
					$story = \model\Stories::get($id);
					if ($story instanceof StoriesEntity) {
						if (\model\Comments::add([
							'user_id'      => $user->user_id,
							'comment_text' => $text,
							'story_id'     => $id,
							'episode_id'   => $episodeId,
						])) {
							Points::award($user,Scores::getBy(4)," برای داستان $story->name");
							return response([
								'message' => 'نظر شما ثبت شد',
							]);
						} else {
							return response([
								'message' => "خطا در ذخیره اطلاعات"
							], 400);
						}
					} else {
						return response([
							'message' => 'داستان یافت نشد'
						], 404);
					}
					break;
				case "book":
					$book = \model\Books::get($id);
					if ($book instanceof BooksEntity) {
						if (\model\Comments::add([
							'user_id'      => $user->user_id,
							'comment_text' => $text,
							'book_id'      => $id
						])) {

							return response([
								'message' => 'نظر شما ثبت شد',
							]);
						} else {
							return response([
								'message' => "خطا در ذخیره اطلاعات"
							], 400);
						}
					} else {
						return response([
							'message' => 'داستان یافت نشد'
						], 404);
					}
					break;
				case "poem":
					$poem = \model\Poems::get($id);
					if ($poem instanceof PoemsEntity) {
						if (\model\Comments::add([
							'user_id'      => $user->user_id,
							'comment_text' => $text,
							'poem_id'      => $id
						])) {
							return response([
								'message' => 'نظر شما ثبت شد',
							]);
						} else {
							return response([
								'message' => "خطا در ذخیره اطلاعات"
							], 400);
						}
					} else {
						return response([
							'message' => 'داستان یافت نشد'
						], 404);
					}
					break;
				case "audioBook":
					$audioBook = \model\AudioBooks::get($id);
					if ($audioBook instanceof AudioBooksEntity) {
						if (\model\Comments::add([
							'user_id'       => $user->user_id,
							'comment_text'  => $text,
							'audio_book_id' => $id,
							'episode_id'    => $episodeId,
						])) {
							Points::award($user,Scores::getBy(4)," برای کتاب صوتی $audioBook->book_name");

							return response([
								'message' => 'نظر شما ثبت شد',
							]);
						} else {
							return response([
								'message' => "خطا در ذخیره اطلاعات"
							], 400);
						}
					} else {
						return response([
							'message' => 'داستان یافت نشد'
						], 404);
					}
					break;
				default:
					return response([
						'message' => 'type parameter required'
					], 400);
			}
		});

		$router->post('/reply-comment/:id', $this->middleware($router), function ($id) {
			$user = Users::findToken(get_header('auth'));
			$text = $this->getParam('text');
			$comment = \model\Comments::get($id);
			if ($comment instanceof CommentsEntity) {
				if (\model\Comments::add([
					'user_id'       => $user->user_id,
					'comment_text'  => $text,
					'story_id'      => $comment->story_id,
					'book_id'       => $comment->book_id,
					'audio_book_id' => $comment->audio_book_id,
					'poem_id'       => $comment->poem_id,
					'reply_id'      => $comment->comment_id
				])) {
					return response([
						'message' => 'پاسخ شما به کامنت ثبت شد'
					]);
				} else {
					return response([
						'message' => "خطا در ذخیره اطلاعات"
					], 400);
				}
			} else {
				return response([
					'message' => 'کامنت یافت نشد'
				], 404);
			}
		});


		$router->post('/like/:id', $this->middleware($router), function ($id) {
			$user = Users::findToken(get_header('auth'));
			$content_id = $this->getParam('content_id');
			$type = $this->getParam('type');
			$data = [
				'user_id'       => $user->user_id,
				'episode_id'    => $id,
				"$type" . "_id" => $id,
			];
			if (Likes::Db()->where($data)->rowCount() > 0) {
				Likes::Db()->where($data)->delete();
				return response([
					'isLiked'       => false,
					//					'message' => '$type disliked by user',
					"$type" . "_id" => $content_id,
					"episode_id"    => $id,
					'user_id'       => $user->user_id
				]);
			} else {
				Likes::add([
					'user_id'       => $user->user_id,
					"$type" . "_id" => $content_id,
					"episode_id"    => $id,
				]);
				Points::award($user,Scores::getBy(3));

				return response([
					'isLiked'       => true,
					//					'message' => '$type liked by user',
					"$type" . "_id" => $content_id,
					"episode_id"    => $id,
					'user_id'       => $user->user_id
				]);
			}
		});
		$router->post('/bookmark/:id', $this->middleware($router), function ($id) {
			$user = Users::findToken(get_header('auth'));
			$content_id = $this->getParam('content_id');
			$type = $this->getParam('type');
			$data = [
				'user_id'       => $user->user_id,
				'episode_id'    => $id,
				"$type" . "_id" => $content_id,
			];
			if (Bookmarks::Db()->where($data)->rowCount() > 0) {
				Bookmarks::Db()->where($data)->delete();
				return response([
					'isBookmarked'  => false,
					//					'message' => '$type disliked by user',
					"$type" . "_id" => $content_id,
					"episode_id"    => $id,
					'user_id'       => $user->user_id
				]);
			} else {
				Bookmarks::add($data);
				return response([
					'isBookmarked'  => true,
					//					'message' => '$type liked by user',
					"$type" . "_id" => $content_id,
					"episode_id"    => $id,
					'user_id'       => $user->user_id
				]);
			}
		});

	}

	public function requiredHeaders(): array {
		return [];
	}
}