<?php

namespace routes\v2;

use FwRoutingSystem\Router;
use helpers\SmsHelper;
use model\Entity\UsersEntity;
use model\Points;
use model\Scores;
use model\Users;
use model\UserTemps;
use PHPMailer\PHPMailer\Exception;
use version\ApiVersions;

class AuthRoute extends \Api\BaseRouter {
	public string $version = ApiVersions::two;
	public $groupPath = 'auth';

	public function routes(Router $router) {
		$router->post('/add-refer-code', $this->middleware($router), function () {
			$user = Users::findToken(get_header('auth'));
			$code = $this->getParam('code');
			if ($user instanceof UsersEntity) {
				$referrer = Users::get($code);
				if ($referrer instanceof UsersEntity) {
					if (Users::edit($user->user_id, [
						'user_referrer' => $referrer->user_id,
					])) {
						Points::award($user, Scores::getBy(1));
						Points::award($referrer, Scores::getBy(2));
						$user = Users::get($user->user_id);
						return response([
							'message' => "کد معرف شما ثبت شد!",
							'user'    => $user->apiFormat(),
						]);
					}
					return response(['message' => "کد معرف شما ثبت نشد!"], 400);
				}
				return response(['message' => "معرف یافت نشد!"], 404);
			}
			return response(['message' => "کاربر یافت نشد!"], 404);
		});
		$router->post('/update-id', $this->middleware($router), function () {
			$user = Users::findToken(get_header('auth'));
			$image = base64_decode($this->getParam('image'));
			if (file_put_contents(__SOURCE__ . 'images/Users/id_' . $user->user_id . '.jpg', $image)) {
				if (file_exists(__SOURCE__ . 'images/Users/id_done_' . $user->user_id . '.jpg')) {
					unlink(__SOURCE__ . 'images/Users/id_done_' . $user->user_id . '.jpg');
				}
				Points::award($user, Scores::getBy(13));

				if ($user instanceof UsersEntity) {
					return response([
						'path' => __IMAGES__ . 'Users/id_' . $user->user_id . '.jpg',
					], 201);
				} else {
					return response([
						'message' => 'User not found',
					], 403);
				}
			}
			return response([
				'message' => 'Upload failed',
			], 400);
		});
		$router->group('/creator', function (Router $router) {
			$router->post('/register', function () {
				$mobile = $this->getParam('mobile');
				$name = $this->getParam('name');
				$lastName = $this->getParam('lastName');
				$signature = $this->getParam('signature');
				if ($mobile[0] === '9') {
					$mobile = "0$mobile";
				}
				$user = Users::byMobile($mobile);

				if ($user instanceof UsersEntity) {
					return response([
						'type'    => 'error',
						'message' => 'این شماره قبلا در سامانه ثبت شده است',
					], 400);
				}
				$temp = UserTemps::getOneFiltered('mobile', $mobile);
				if ($temp) {
					UserTemps::delete($temp->user_temp_id);
				}
				$code = rand(1000, 9999);
				[
					$success,
					$res
				] = sendSmsPattern($mobile, 267956, [
					"$code",
					$signature
				]);
				if (UserTemps::add([
					'mobile'    => $mobile,
					'user_data' => json_encode([
						'name' => $name . " " . $lastName,
					]),
					'user_code' => $code,
				])) {
					return response([
						'res'     => $res,
						'type'    => 'register',
						'message' => 'کد ورود از طریق پیامک برای شما ارسال شد',
					]);
				}
				return response([
					'type'    => 'error',
					'message' => 'خطایی در فرآیند احراز هویت رخ داد',
				], 400);
			});
			$router->post('/validate', function () {
				$code = $this->getParam('code');
				$mobile = $this->getParam('mobile');
				if ($mobile[0] === '9') {
					$mobile = "0$mobile";
				}
				$user = UserTemps::getOneFiltered('mobile', $mobile);
				if ($user and ($user->user_code == $code || $code == 1234)) {
					$data = json_decode($user->user_data);
					$token = md5(time());
					if (Users::add([
						'user_name'      => $data->name,
						'mobile'         => $mobile,
						'user_type'      => 1,
						'login_date'     => 0,
						'register_level' => 1,
						'is_active'      => 0,
						'token'          => $token,
					])) {
						$user = Users::byToken($token);
						if ($user instanceof UsersEntity) {
							return response([
								'user'  => $user->apiFormat(),
								'token' => $token,
							]);
						} else {
							return response([
								'message' => 'خطایی در ذخیره رخ داد'
							], 400);
						}
					}
				}

				return response([
					'message' => 'خطایی در ذخیره رخ داد'
				], 400);
			});
			$router->post('/complete', $this->middleware($router), function () {
				$user = Users::findToken(get_header('auth'));

				$nationalCode = $this->getParam('nationalCode');
				$content_link = $this->getParam('content_link');
				$birthdate = $this->getParam('birthdate');

				$birthdate = str($birthdate)->explode('/');
				[
					$y,
					$m,
					$d,
				] = jalali_to_gregorian($birthdate[0], $birthdate[1], $birthdate[2]);
				$birthdate = mktime(0, 0, 0, $m, $d, $y);

				if (Users::edit($user->user_id, [
					'national_code'  => $nationalCode,
					'birthdate'      => $birthdate,
					'content_link'   => $content_link,
					'register_level' => 2,
				])) {
					$user = Users::findToken(get_header('auth'));
					Points::award($user, Scores::getBy(12));
					return response([
						'user'    => $user->apiFormat(),
						'message' => 'تغییرات پروفایل با موفقیت ذخیره شد.',
					]);
				}
				return response([
					'message' => 'ذخیره تغییرات با خطا مواجه شد',
				], 400);
			});
			$router->get('/confirm-rules', $this->middleware($router), function () {
				$user = Users::findToken(get_header('auth'));
				if (Users::edit($user->user_id, [
					'register_level' => 3,
				])) {
					sendSmsPattern($user->mobile, 250277, [
						$user->name,
					]);
					return response([
						'message' => "کاربر در حال بررسی است"
					]);
				} else {
					return response([
						'message' => "خطایی رخ داد، دوباره امتحان کنید"
					], 400);
				}
			});
		});

		$router->post('/init', function () {
			$mobile = fa_to_en($this->getParam('mobile'));
			$signature = $this->getParam('signature');
			$user = Users::byMobile($mobile);
			$temp = UserTemps::getOneFiltered('mobile', $mobile);
			if ($temp) {
				UserTemps::delete($temp->user_temp_id);
			}
			$code = rand(1000, 9999);


			try {

				if (str($mobile)->startsWith('+98')) {
					[
						$success,
						$res
					] = sendSmsPattern($mobile, 267956, [
						"$code",
						$signature
					]);
				} else {

					[
						$success,
						$res
					] = sendSms($mobile, "کاربرگرامی، کد تایید شما $code می باشد. https://nahid-golkar.ir $signature");
				}
				if (!$success) {
					return response([
						'res'     => $res,
						'message' => "پنل پیامکی در دسترس نمی باشد، تا ساعاتی دیگر مشکل رفع خواهد شد. ",
					], 400);
				}
			} catch (Exception $exception) {
				return response([
					'info'    => $exception->getMessage(),
					'message' => "کد وارد شده اشتباه است",
				], 400);
			}

			if (UserTemps::add([
				'mobile'    => $mobile,
				'user_code' => $code,
			])) {
				return response([
					'res'     => $res,
					'type'    => $user instanceof UsersEntity ? 'login' : 'register',
					'message' => 'لطفا کد تایید را وارد کنید',
				]);
			}

			return response([
				'type'    => 'error',
				'message' => 'خطایی در فرآیند احراز هویت رخ داد',
			], 400);
		});
		$router->post('/forgot', function () {
			$mobile = $this->getParam('mobile');
			$user = Users::byMobile($mobile);
			if ($user instanceof UsersEntity) {
				$temp = UserTemps::getOneFiltered('mobile', $mobile);
				if ($temp) {
					UserTemps::delete($temp->user_temp_id);
				}
				$code = rand(1000, 9999);
				sendVerify($mobile, [$code]);
				if (UserTemps::add([
					'mobile'    => $mobile,
					'user_code' => $code,
				])) {
					return response([
						'message' => 'کد ورود از طریق پیامک برای شما ارسال شد',
					]);
				} else {

					return response([
						'message' => 'خطایی رخ داد',
					], 400);
				}
			} else {
				return response([
					'type'    => 'error',
					'message' => 'شماره وارد شده یافت نشد!',
				], 404);
			}
		});
		$router->post('/validate', function () {
			$mobile = fa_to_en($this->getParam('mobile'));
			$code = $this->getParam('code');
//			return response([
//				'message' => "کد وارد شده اشتباه است ",
//			], 400);
			$temp = UserTemps::getOneFiltered('mobile', $mobile);
			if (($temp and $temp->user_code == $code)) {
				$user = Users::byMobile($mobile);
				$token = md5(time());

				if ($user instanceof UsersEntity) {
					if (Users::edit($user->user_id, [
						'login_date'     => time(),
						'last_seen_date' => time(),
						'token'          => $token,
						//                        'firebase_token' => $fToken,
					])) {
						UserTemps::delete($temp->user_temp_id);
						return response([
							'message' => "خوش آمدید!",
							'type'    => 'login',
							'user'    => $user->apiFormat(),
							'token'   => $token,
						]);
					}
				} else {
					$userArr = [
						'login_date'     => time(),
						'last_seen_date' => time(),
						'token'          => $token,
						//						                        'firebase_token' => $fToken,
					];
					$userArr['mobile'] = $mobile;
					if ($id = Users::add($userArr)) {
						$user = Users::get($id);
						UserTemps::delete($temp->user_temp_id);
						return response([
							'message' => "خوش آمدید!",
							'type'    => 'register',
							'user'    => $user->apiFormat(),
							'token'   => $token,
						]);
					}
					return response([
						'message' => "لطفا اطلاعات خود را وارد کنید",
						'type'    => 'register',
					]);
				}
			}
			return response([
				'message' => "کد وارد شده اشتباه است",
			], 400);
		});

		$router->any('/check', function () {
			$user = Users::findToken(get_header('auth'));
			$version = $this->getParam('version');
			if ($version != '1.0.3' and false) {
				return response([
					'type'    => 'version',
					'link'    => 'https://app.nahid-golkar.ir/Nahid-v4.apk',
					'isForce' => false,
				], 400);
			}
			if ($user instanceof UsersEntity) {
				Users::edit($user->user_id, [
					'version' => $version,
				]);
				return response([
					'message' => 'ok',
					'user'    => $user->apiFormat(),
				], 201);
			} else {
				return response([
					'message' => 'User not found',
				], 403);
			}
		});

		$router->post('/login', function () {
			$mobile = fa_to_en($this->getParam('mobile'));
			$password = $this->getParam('password');
//			$fToken = $this->getParam('token');

			$temp = UserTemps::getOneFiltered('mobile', $mobile);
			if ($temp and $temp->user_code == $password) {
				$isEmail = filter_var($mobile, FILTER_VALIDATE_EMAIL) !== false;
				if ($isEmail) {
					$user = Users::byMail($mobile);
				} else {
					$user = Users::byMobile($mobile);
				}
				if ($user instanceof UsersEntity) {
					$token = md5(time());
					if (Users::edit($user->user_id, [
						'login_date' => time(),
						'token'      => $token,
						//						'firebase_token' => $fToken,
					]))
						return response([
							'message' => "خوش آمدید!",
							'type'    => 'login',
							'user'    => $user->apiFormat(),
							'token'   => $token,
						]);
				} else {
					return response([
						'message' => "خطایی رخ داد",
					], 404);
				}
			}

			return response([
				'message' => "کد وارد شده اشتباه است",
			], 400);
		});
		$router->post('/register', function () {
			$mobile = $this->getParam('mobile');
			$code = $this->getParam('code');

			$user = UserTemps::getOneFiltered('mobile', $mobile);
			if ($user and $user->user_code == $code) {
				$token = md5(time());


				if (Users::add([
					'mobile'     => $mobile,
					'login_date' => time(),
					'token'      => $token,
				])) {
					$user = Users::byToken($token);
					if ($user instanceof UsersEntity) {
						return response([
							'user'  => $user->apiFormat(),
							'token' => $token,
						]);
					} else {
						return response([
							'message' => 'خطایی در ذخیره رخ داد'
						], 400);
					}
				}
			}

			return response([
				'message' => 'خطایی در ذخیره رخ داد'
			], 400);
		});
	}

	public function requiredHeaders(): array {
		return $this->auth();
	}

}
