<?php

namespace routes\v2;

use Api\BaseRouter;
use FwRoutingSystem\Router;
use model\Entity\MembershipsEntity;
use model\Entity\PointsEntity;
use model\Entity\RewardCategoriesEntity;
use model\Entity\RewardsEntity;
use model\Entity\ScoresEntity;
use model\Points;
use model\RewardCategories;
use model\Rewards;
use model\Scores;
use model\Users;
use version\ApiVersions;

class  ClubRoute extends BaseRouter {

	public string $version = ApiVersions::two;
	public $groupPath = 'club';

	public function routes(Router $router) {
		$router->get('/', $this->middleware($router), function () {
			$user = Users::findToken(get_header('auth'));
			$scores = Scores::Db()->get()->map(function (ScoresEntity $scoresEntity) {
				return $scoresEntity->apiFormat();
			})->values();
			$rewards = RewardCategories::Db()->get()->map(function (RewardCategoriesEntity $rewardCategoriesEntity) {
				return $rewardCategoriesEntity->apiFormat();
			})->values();
			$points = Points::Db()->where('user_id', $user->user_id)->get()->map(function (PointsEntity $pointsEntity) {
				return $pointsEntity->apiFormat();
			});
			return response([
				'scores'  => $scores->values(),
				'rewards' => $rewards->values(),
				'points'  => $points->values(),
			]);
		});
		$router->post('/buy', $this->middleware($router), function () {
			$reward = $this->getParam('reward');
			$user = Users::findToken(get_header('auth'));

			$reward = Rewards::get($reward);
			if ($reward instanceof RewardsEntity) {
				$neededPoints = $reward->required_points;
				$currentPoints = $user->points;
				if ($currentPoints >= $neededPoints) {
					if (Points::buy($user, $reward)) {
						switch ($reward->category_id) {
							case 3:
								$user = Users::get($user->user_id);
								$meta = json_decode($reward->meta);
								return response([
									'user'         => $user->apiFormat(),
									'type'         => 'discount',
									'discount'     => $meta->discount,
									'discountCode' => "FRIWUEC",
									'message' => "کد تخفیف $meta->discount برای برای شما فعال شد.",

								]);
							case 4:
								$meta = json_decode($reward->meta,true);
								$value = price_format($meta['help']);
								$user = Users::get($user->user_id);
								return response([
									'user'    => $user->apiFormat(),
									'type'    => 'charity',
									'help'    => $value,
									'charity' => "بنیاد خیریه بنک دار",
									'message' => "مبلغ $value به بنیاد خیریه بنک دار اهدا شد.",
								]);
							case 1:
								$meta = json_decode($reward->meta,true);
								$membership = \model\Memberships::Db()->where('membership_duration', '=', @$meta['days'])->get()->first;
								if ($membership instanceof MembershipsEntity) {
									$duration = $membership->duration;
									Users::edit($user->user_id, [
										'membership_id'           => $membership->membership_id,
										'membership_activated_at' => time(),
										'membership_expired_at'   => strtotime("+$duration days", time()),
									]);
									$user = Users::get($user->user_id);
									return response([
										'user'    => $user->apiFormat(),
										'message' => "اشتراک $membership->name برای شما فعال شد.",
									]);
								}
						}
						return response([
							'message' => "خطایی رخ داد"
						], 400);
					}
					return response([
						'message' => "خطایی در ثبت امتیاز رخ داد"
					], 403);
				}
				return response([
					'message' => "موجودی امتیاز شما کافی نمی باشد"
				], 403);
			}
			return response([
				'message' => "جایزه یافت نشد"
			], 404);
		});
		$router->get('/guides', function () {
			$scores = Scores::Db()->get()->map(function (ScoresEntity $scoresEntity) {
				return $scoresEntity->apiFormat();
			})->values();
			$rewards = RewardCategories::Db()->get()->map(function (RewardCategoriesEntity $rewardCategoriesEntity) {
				return $rewardCategoriesEntity->apiFormat();
			})->values();
			return response([
				'scores'  => $scores->values(),
				'rewards' => $rewards->values(),
			]);
		});
	}

	public function requiredHeaders(): array {
		return [];
	}

}